"The House of Mystery" by "James G. Lynch"

The story genre is "Fiction".

The story headline is "An Interactive Fantasy".

The story creation year is 2018.

The Release number is 4.

The story description is "Description: A house in the middle of the woods has being sitting here for years. Rumors have speculated that the person who once owned this house has mysteriously disappeared off the face of the earth and no one seems to remember anything about it at all. As an investigator, it's up to you to check and see what secrets lie within this treacherous home. Uncover the lost bits of somebody's past and find out what really happened here.

This game was initally a project for my New Media Perspectives class in college. I was never expecting to make a fully finished game out of it, but after a while I began it get interested in what I was making and expanded upon what I've started. Now after about 2 months of hard work I've been able to make my first ever text-based game. I hope you enjoy what I've made so far. If you ever happen to find a bug or any spelling/grammar error, please contact me at 0516jgl@gmail.com so that I can fix it ASAP. Thank you and enjoy! (P.S. - Anyone who sends me weird and stupid crap or whatever will be blocked and/or put into the black hole that is my spam folder.)

Disclaimer: This game has some mild language and disturbing content that may not be comfortable for most people. Not all content I include is rightful mine. Full credit goes to anything that is not owned by me.

Original cover art made by AppleSin (Mistrie Orange). All rights reserved and such."

[Release Content]
Release along with cover art ("The book of void.").
Release along with the library card.
Release along with the private source text.
Release along with an introductory booklet and introductory postcard.
Release along with a "Classic" website. 
Release along with the "Vorple" interpreter.

[NOTICE TO DATA-MINERS: Unless you know what exactly you are doing here, please refrain from changing any of code. This may cause the game to have frequent errors and crashes because of missing rules, unfinished actions, or words that the game does not comprehend so much. Inform 7 uses natural language as its code layer, in other words, it uses Standard English sentences as its coding and is a learning machine. If it happens to find something that it doesn't understand, it will refuse to play the game properly until the error has been fixed. I can't stop you from tearing this game piece by piece but I can warn you about the risks your about to experience and prevent unexpected consequences. If you do however find any problems or bugs in the game let me know so that I can resolve them as best as possible. Same thing goes for any grammar, spelling or punctuation you find. I tend to be a grammar nazi to myself every one in a while, especially when I just proofread this entire source layer like 10,000 times and still manage to overlook a misspelled word. Also the spell checker on this program is sometimes inaccurate. It's annoying, I know. But yeah, that's about it. Thank you for listening and enjoy this game to your hearts content!]

Section 0.1 - Extensions

[Built-in Extensions]
Include Basic Screen Effects by Emily Short.
Include Basic Help Menu by Emily Short.
Include Vorple Notifications by Juhana Leinonen.

[Game Start]
When play begins:
	center "Welcome to 'The House of Mystery.'";
	wait for any key;
	say line break;
	center "You've been told to retrieve a special artifact from this illusionary building.";
	wait for any key;
	center "Whatever this 'artifact' could be is beyond me.";
	wait for any key;
	center "Go now and find it, but beware,";
	wait for any key;
	center "there are many traps and challenging puzzles for you to solve along the way.";
	wait for any key;
	center "The choices you make matter the most. Let's hope you make the best decisions.";
	wait for any key;
	center "Good Luck!";
	pause the game;
	now the left hand status line is "[location]";
	now the right hand status line is "Turns: [turn count]".

Before starting the virtual machine:
	now the left hand status line is "";
	now the right hand status line is "".

Section 0.2 - Index

[In hand at Start]
The player is wearing a black cap and a brown jacket. The player is carrying a gold watch and small map. The description of the player is "Narcissist."
The printed name of the small map is "Map of the House".
Understand "map 1" as small map.

The description of the gold watch is "It's for when you need to know what time it is. You've had this watch ever since your grandfather passed away and you hold onto it as a treasured memory of him. Right now the watch hands are stuck because time is irrelevant in a game most of time."
The description of the black cap is "This cap has a symbol of that strange letter 'S' you and your classmate friends would draw in notebooks all the time. You have yet to know what that even means."
The description of the brown jacket is "This zipper jacket you wear is dated and on the front reads 'Abercrombie & Fitch: 1892.' You've had this since you were in middle school."

Instead of attacking yourself:
	say "Suicide is not a definite answer to any problem whatsoever. Stop it and get some help."
Instead of dropping the gold watch:
	say "That item is of importance to you. You cannot get rid of it."
Instead of dropping the brown jacket:
	say "That item is of importance to you. You cannot get rid of it."
Instead of dropping the black cap:
	say "That item is of importance to you. You cannot get rid of it."

[Turn counter]
Every turn when the turn count is 1996:
	say "Today, please. Today!"

Section 0.3 - Actions

[New actions list]
Kicking is an action applying to one thing.
Understand "kick [something]" as kicking.
After kicking something: 
	say "That is not acceptable behaviour."
After kicking the dog when the dog is tame for the first time: 
	say "Don't kick the dog.";
	now the dog is startled;
	now the description of the dog is "The dog is [state]. Would be best to leave him alone."
After kicking the dog for the second time: 
	say "I said don't kick the dog."
After kicking the dog for the third time: 
	say " What part of 'don't kick dog' don't you understand."
After kicking the dog for the fourth time: 
	end the story saying "Ok, just for that I'm going to end the game for you because your being an abusive animal beater. Let's see what the animal rights association has to say about you."

Digging it with is an action applying to two things.
Understand "dig [something] with [something]" as digging it with.
After digging something with something:
	say "I don't think that will work."
Check digging it with:
	if the player is not carrying the shovel:
		say "You'll need a special tool first."

Breaking it with is an action applying to two things.
Understand "break [something] with [something]" as breaking it with.
After breaking something with something:
	say "That's not necessary most of the time."
Check breaking it with:
	if the player is not carrying the crowbar:
		say "You'll need something strong, stronger than a hammer possibly."

Saying sorry to is an action applying to one thing.
Understand "say sorry to [an animal]" as saying sorry to.
After saying sorry to something:
	say "What's there to apologize for?"

Playing is an action applying to one thing.
Understand "play [something]" as playing.
After playing something:
	say "You find no enjoyment in that."

Using it on is an action applying to two things.
Understand "use [something] on [something]" as using it on.
After using something on something:
	say "No effect."

Petting is an action applying to one thing.
Understand "pet [an animal]" as petting.
After petting the dog:
	say "You pet the dog. He enjoys that very much."
Instead of petting the dog when the dog is startled:
	say "Now is not the best time for that."
Instead of petting the dog when the dog is skiddish:
	say "He backs away from you."
Instead of petting the dog when the dog is upset:
	say "He refuses the offer and will not allow you to touch him."
Instead of petting the dog when the dog is stubborn:
	say "He's not in the mood for that."
After petting the stinkbug:
	say "I hope you'll wash your hands after this."

Walking up to is an action applying to one thing.
Understand "walk up to [something]" as walking up to.
After walking up to something:
	say "You feel closer than before."

Searching through is an action applying to one thing.
Understand "search through [something]" as searching through.
After searching through something:
	say "Nothing here."
Instead of searching through an animal:
	say "That command only works on inanimate objects."
Instead of searching through a man:
	say "Not a lot of humans are present this game to pick pockets except for you, but I have my doubts on that."

Hugging is an action applying to one thing.
Understand "hug [an animal]" as hugging.
After hugging the dog:
	say "You feel all warm and fuzzy inside."
Instead of hugging the dog when the dog is startled:
	say "Nope. Not today."
Instead of hugging the dog when the dog is skiddish:
	say "Your a monster to him so back off."
Instead of hugging the dog when the dog is upset:
	say "That does not work."
Instead of hugging the dog when the dog is stubborn:
	say "If this did constitute as 'saying sorry' I would allow it but since that's non-verbal and takes more work to code in, I can't.";
	say line break;
	wait for any key;
	say "Sorry."
Instead of hugging the stinkbug:
	say "I wouldn't."
Instead of hugging the fake dog:
	say "That dog rejects your emotional embraces."
Instead of hugging the white wyvern when the white wyvern is menacing:
	say "Please don't try."
Instead of hugging the white wyvern when the white wyvern is bewildered:
	say "Try something else."
After hugging the white wyvern when the white wyvern is content:
	say "Your friends would be so jealous if you told them about this."
After hugging the white wyvern when the white wyvern is curious:
	say "He feels less lonely now that your here."
Instead of hugging a man:
	say "That's a bit weird."

Talking to is an action applying to one thing.
Understand "talk to [a man]" as talking to.

[Useless commands just for laughs]
Swearing at is an action applying to one thing.
Understand "swear at [something]", "cuss at [something]", and "curse at [something]" as swearing at.
Instead of swearing at something: 
	say "Watch your profanity! There are children playing this game, I think."

Marrying is an action applying to one thing.
Understand "marry [something]" as marrying.
Instead of marrying something:
	say "I'm pretty sure nothing in this game understands what the emotion of 'love' is. Not even myself and that's saying something."

Escaping is an action applying to nothing.
Understand "escape" and "run away" as escaping.
Instead of escaping:
	say "What are you running away from?"

Instead of kissing an animal:
	say "That's... um, no."
Instead of kissing a man:
	say "I can't allow that due to... certain conditions that I cannot explain in full details."
Instead of attacking the dog:
	say "No!"
Instead of marrying the dog:
	say "That's not necessary. (Not even you can repair his broken heart.)"

Telling the computer its stupid is an action applying to nothing.
Understand "Tell the computer its stupid", "Tell the game its stupid", and "Tell the creator he's stupid" as telling the computer its stupid.
After telling the computer its stupid:
	say "I may be stupid, but at least I have common sense."

Dividing zero is an action applying to nothing.
Understand "divide 0 by 0" as dividing zero.
After dividing zero:
	say "So you want me to implode time and space as we know it. Is that it? Well... I can't. For starters that's logically impossible. If I were to do that then me, you, this game and every other thing in this known universe would collapse in on itself and cease to exist for all of eternity because you decided to wanted to make a stupid hard task a possible outcome. But if this still does not suffice you then maybe you should ask Siri and hear what she has to say about your unobtainable request."

Cheating is an action applying to nothing.
Understand "UUDDLRLRBA" as cheating.
After cheating:
	say "Sorry, I don't speak Konami."

After jumping:
	say "What are you a plumber?";
	if player consents:
		say "Well too bad. You move-set is in another castle.";
		wait for any key;
		say "And also your princess.";
	otherwise:
		say "Oh really?"

[Water rule]
A thing can be waterproof or porous. A container is usually waterproof. An animal is usually waterproof.

A thing can be sodden or dry.

A container can be waterfilled or empty.

Before printing the name of a sodden thing: say "sodden ". Understand the sodden property as describing a thing.

Every turn:
	follow the liquid distribution rules. 

The liquid distribution rules is a rulebook.

A liquid distribution rule: 
	repeat with item running through containers: 
		if the item is open and the item is empty and the item is in a waterfilled container: 
			now the item is waterfilled; 
			if the player can see the item, say "[The item] fills up with water, of course.".

A liquid distribution rule: 
	repeat with item running through things in a waterfilled container: 
		if the item is porous and the item is dry: 
			if the player can see the item, say "[The item] soaks through."; 
			now the item is sodden.

Filling it with is an action applying to two things.
Understand "fill [container] with [something]" as filling it with.
Check filling it with:
	if the player is not carrying the bucket:
		say "To do this, you'll need an empty container."

Pouring it on is an action applying to two things.
Understand "pour [container] on [something]" as pouring it on.
Check pouring it on:
	if the player is not carrying the bucket:
		say "To do this, you'll need a filled container."

[Battle mechanics]
Dodging is an action applying to one thing.
Understand "dodge [a man]" and "guard [a man] attack" as dodging.

Skipping turn on is an action applying to one thing.
Understand "Wait for [a man]" as skipping turn on.

[Block/Unblock rules list]
The can't take other people rule is not listed in the check taking rulebook. [Living creatures are carryable now. Needed for dog later.]

The block attacking rule is not listed in the check attacking rulebook. [Now you can defend yourself unless you have a weapon.]
After taking the butcher's knife:
	say "Now you can defend yourself if needed."
After taking the shovel:
	say "Now you have a bit of defense and offense on your side."
After taking the crowbar:
	say "Now you have a REAL weapon of destruction. (Don't actually break everything on sight please. 'Play responsibly,' says literally every casino on this planet.)"
Check attacking:
	if the player is not carrying the butcher's knife:
		say "You need something to attack with. Your bare hands will not do."

The block throwing at rule is not listed in the check throwing it at rulebook.
The futile to throw things at inanimate objects rule is not listed in the check throwing it at rulebook.
After taking the rock:
	say "This could come in handy maybe."
Check throwing at:
	if the player is not carrying the rock:
		say "Whatever you have on you is not good for chucking."
After throwing the rock at a window:
	end the story saying "Your not good at listening to me, are you."
After throwing the rock at a stained window:
	end the story saying "Your not good at listening to me, are you."

[Fake command]
To fake command:
	say "[line break][command prompt] [bold type]";
	wait for any key;
	say "G";
	wait for any key;
	say "a";
	wait for any key;
	say "m";
	wait for any key;
	say "e";
	wait for any key;
	say " ";
	wait for any key;
	say "O";
	wait for any key;
	say "v";
	wait for any key;
	say "e";
	wait for any key;
	say "r";
	wait for any key;
	say roman type;
	say line break;

To fake command 2:
	say "[line break][command prompt] [bold type]";
	wait for any key;
	say "I'm";
	wait for any key;
	say " here";
	wait for any key;
	say " for";
	wait for any key;
	say " you.";
	wait for any key;
	say roman type;
	say line break;


To fake command 3:
	say "[line break][command prompt] [bold type]";
	wait for any key;
	say "Y";
	wait for any key;
	say "e";
	wait for any key;
	say "s";
	wait for any key;
	say roman type;
	say line break;

Section 0.4 - Things

[Damaged Things]
A thing can be damaged or undamaged.
The trap door is undamaged.
The clown doll is undamaged.

[Thing multiplier list]
[Chairs]
A chair is a kind of enterable supporter.
The white chair is a chair.
The small chair is a chair.
The recliner chair is a chair.
The broken recliner chair is a chair.
The black chair is a chair.
The bloody chair is a chair.
The shattered chair is a chair.
The piano bench is a chair.
The sturdy stool is a chair.
The non-sturdy stool is a chair.

A withered chair is a kind of enterable supporter.

[Couches]
A couch is a kind of enterable supporter.
The large couch is a couch.
The small couch is a couch.
Understand "sofa" as couch.

A shredded couch is a kind of enterable supporter.
Understand "sofa" as shredded couch.

[Beds]
A bed is a kind of undamaged enterable supporter.
The queen-size bed is a bed.
The guest bed is a bed.
The master's bed is a bed.
The wrecked bed is a bed.
The king-size bed is a bed.
The torn-up bed is a bed.

[Sinks]
A sink is a kind of device.
The duel sink is a sink.
The small sink is a sink.
The small upstairs sink is a sink.
The inverted sink is a sink.
The twin sink is a sink.
The warped sink is a sink.

[Toilets]
A toilet is a kind of enterable supporter.
The fancy toilet is a toilet.
The small toilet is a toilet.
The inverted toilet is a toilet.
The bent toilet is a toilet.

[Tables]
A table is a kind of supporter.
The coffee table is a table.
The large table is a table.
The desk is a table.
The split table is a table.
The worn-out table is a table.
The bloody table is a table.
The broken desk is a table.

[Windows]
A window is a kind of scenery thing.
The large window is a window.
The upstairs window is a window.
The cracked large window is a window.

A stained window is a kind of scenery thing.

[TV's]
A television is a kind of device.
The old television is a television.
The small television is a television.
The dead television is a television.
The small broken television is a television.
Understand "tv" and "boobtube" as television.

[Cages]
A rickety cage is a kind of enterable container.

[The Mysterious Papers]
A mysterious paper is a kind of thing.
Note #1 is a mysterious paper.
Note #2 is a mysterious paper.
Note #3 is a mysterious paper.
Note #4 is a mysterious paper.
Note #5 is a mysterious paper.
Note #6 is a mysterious paper.
Note #7 is a mysterious paper.
Note #8 is a mysterious paper.
Note #9 is a mysterious paper.
Understand "Note 1" as Note #1. Understand "Note 2" as Note #2. Understand "Note 3" as Note #3. Understand "Note 4" as Note #4. Understand "Note 5" as Note #5. Understand "Note 6" as Note #6. Understand "Note 7" as Note #7. Understand "Note 8" as Note #8. Understand "Note 9" as Note #9.

Instead of dropping a mysterious paper:
	say "This is important, don't lose it."

[Undead creatures]
A zombie is a kind of man.
Zombie 1 is a zombie. The printed name of Zombie 1 is "A Zombie".
Zombie 2 is a zombie. The printed name of Zombie 2 is "The Left Zombie".
Zombie 3 is a zombie. The printed name of Zombie 3 is "The Right Zombie".
Zombie 4 is a zombie. The printed name of Zombie 4 is "The Middle Zombie".
Zombie 5 is a zombie. The printed name of Zombie 5 is "The Final Zombie".
Understand "undead" as zombie.
Understand "left zombie" as Zombie 2.
Understand "right zombie" as Zombie 3.
Understand "middle zombie" as Zombie 4.

Instead of taking a zombie:
	say "That's not allowed."
Instead of walking up to a zombie:
	say "Keep your distance."

Section 0.5 - Values

[Mental states]
State is a kind of value. The states are content, startled, tame, upset, skiddish, chill, stubborn, calm, menacing, bewildered, curious, scared, agitated, unamused, glad, sad, petrified, mortified, worried, disgusted, and quiet.

A dog is an animal. The dog is male. The dog has a state. The dog is tame.
The printed name of the dog is "Australian Shepherd".

The white wyvern has a state. The white wyvern is menacing.

[Physical attributes]
Attribute is a kind of value. The attributes are smoldering, soggy, cool, attack, dodge, vulnerable, and wait.

The fireplace has an attribute. The fireplace is smoldering.
The firewood has an attribute. The firewood is smoldering.

Zombie 1 has an attribute. Zombie 1 is attack.
Zombie 2 has an attribute. Zombie 2 is attack.
Zombie 3 has an attribute. Zombie 3 is wait.
Zombie 4 has an attribute. Zombie 4 is wait.
Zombie 5 has an attribute. Zombie 5 is attack.

[Final Boss patterns]
Attack pattern is a kind of value. The attack patterns are readying, guarding, and defenseless.

The doppleganger has an attack pattern. The doppleganger is guarding.

Section 0.6 - Figures

[2 Maps]
Figure 1 - Map is the file "Map 1.png".
Figure 2 - New Map is the file "Map 2.png".

[1st Map]
The description of the small map is "Here is a map of the entire house. The abbreviations of each room goes from First Floor, Second Floor, and Lower Floor:

LR - Living Room (Your starting point)[line break]DR - Dining Room[line break]Kt - Kitchen[line break]HI - Hallway[line break]Bd - Bedroom[line break]Bt - Bathroom[line break]Md - Mudroom[line break]Bc - Backyard

SF - Second Floor[line break]UB - Upstairs Bathroom[line break]GB - Guest Bedroom[line break]MB - Master Bedroom

Bs - Basement[line break]Cl - Cellar[line break]Bc - Backroom[line break](CE is not a room that can be entered unless a certain requirement is made.)

Directions: North, South, East, West, Up, Down, Outside, and Inside".

After examining the small map:
	display Figure 1 - Map.

Instead of dropping the small map:
	say "That's an important item. You can't afford to lose it."

[2nd Map]
The large map is a thing.
The printed name of the large map is "Map of the House (Updated)".

The description of the large map is "I hope you remembered:

Left half: Original House[line break]Right half: Inverted House".

After examining the large map:
	display Figure 2 - New Map.

Instead of dropping the large map:
	say "That's still important. Don't go throwing it away."

Section 0.7 - Conversations

[The dog]
After asking the dog about "the house":
	say "He doesn't like talking about his own home."
After asking the dog about "Micheal":
	say "(Maybe you should ask something else.)"
After asking the dog about "Flammie":
	say "He's dead silent."
After asking the dog about "the notes":
	say "His minds a bit foggy about these notes."
After asking the dog about "the machines":
	say "That was a long time ago and doesn't even remember where their at."

[The mouse]
After asking the mouse about "the house":
	say "It's been a while since she saw the outside world. All she can tell you is not to trust everything you see here."
After asking the mouse about "Micheal":
	say "She used to know that man before he disappeared. When she was young, she lived a house next door to him.";
	wait for any key;
	say "Micheal would always be busy in his work and she would always hear him from underneath the ground.";
	wait for any key;
	say "Whatever happened to him was not a pleasant one.";
	wait for any key;
	say "She can barely make out the rest.";
	wait for any key;
	say "As for herself, she wondered off in this strange world and never came back."
After asking the mouse about "the clock":
	say "It's nice and cozy. She would often get freaked out over the clocks chime each hour.";
	wait for any key;
	say "But then, one day, it broke all of a sudden and she left it that way."
After asking the mouse about "going home":
	say "She's been thinking of going back home for a long time. But she can't help but think that he's still here somewhere."
After asking the mouse about "Flammie":
	say "She doesn't seemed intimidated about a dragon existing.";
	wait for any key;
	say "If your planning on seeing him she suggests you approach him slowly.";
	wait for any key;
	say "He may look big and ferocious, but he's actually gentle and is feeling troubled.";
	wait for any key;
	say "She pities him."
After asking the mouse about "the notes":
	say "That guy was always writing logs about himself, as if expecting someone to read them when the time came.";
	wait for any key;
	say "He may have been foreshadowing his own future to come."
After asking the mouse about "the machines":
	say "Those bring back terrible memories of hers."

[The wyvern]
After asking the white wyvern about "itself":
	if the white wyvern is content:
		say "He's been here for a long time, waiting for him to come back.";
	otherwise:
		say "[if the white wyvern is curious] He wants to leave but only after everything has been resolved."
After asking the white wyvern about "Micheal":
	if the white wyvern is content:
		say "That's a name he wishes to not hear.";
	otherwise:
		say "[if the white wyvern is curious] (Perhaps you should talk about something else.)"
After asking the white wyvern about "the egg":
	if the white wyvern is content:
		say "Even though he were still in the egg at the time, he could still sense everything from outside.";
	otherwise:
		say "[if the white wyvern is curious] After he was put into the fridge, he went into a state of hibernation and woke up here somehow.";
After asking the white wyvern about "the house":
	if the white wyvern is content:
		say "This house was made after that catastrophe happened.";
		wait for any key;
		say "After that, he lost all hope in everything and fell into a state of depression and grief for some time.";
	otherwise:
		say "[if the white wyvern is curious] While he may still be holding a grudge against him, he can't stay mad about it.";
		wait for any key;
		say "[if the white wyvern is curious] His only wish to be free from the cursed land."
After asking the white wyvern about "the room":
	if the white wyvern is content:
		say "This room was like this when he got here.";
		wait for any key;
		say "It may had to do with what happened downstairs.";
		wait for any key;
		say "He dares not to even speak about the screams he heard down there.";
	otherwise:
		say "[if the white wyvern is curious] Even with all this red he still managed to stay clean and white without any horrible stains."
After asking the white wyvern about "the notes":
	if the white wyvern is content:
		say "That's none of his business to be concerned about.";
	otherwise:
		say "[if the white wyvern is curious] It would hurt him to hear his words again."
After asking the white wyvern about "the mouse":
	if the white wyvern is content:
		say "It was the only real company he had every once in the while.";
		wait for any key;
		say "She understand his struggle and watched over him.";
		wait for any key;
		say "He appreciates the support she gives.";
	otherwise:
		say "[if the white wyvern is curious] He wonders he she is doing with all this happening.";
		wait for any key;
		say "[if the white wyvern is curious] Their both in denial."

[The zombie]
After asking a zombie about "thriller":
	say "The zombie begins to dance as you mentioned this to it."

Section 0.8 - Debugging Cheats - Not for release

[None of them for you. Move along.]
Universal rule 1 is an action applying to nothing.
Understand "imsickofalltheselockeddoors" as universal rule 1.
Carry out universal rule 1: now all doors are unlocked;
now all doors are unlocked.
Report universal rule 1: say "Open Sesame!"

Universal rule 2 is an action applying to nothing.
Understand "magicmirroronthewall" as universal rule 2.
Carry out universal rule 2: now the player is carrying the scepter.
Report universal rule 2: say "Whose the fairest? Not you, cheater!"

Universal rule 3 is an action applying to nothing.
Understand "myheadisnaked" as universal rule 3.
Carry out universal rule 3: now the player is carrying the red pinned hat.
Report universal rule 3: say "Then don't go out in public."

Universal rule 4 is an action applying to nothing.
Understand "itsfreezinginhere" as universal rule 4.
Carry out universal rule 4: now the player is carrying the thermal coat.
Report universal rule 4: say "Then put on some layers."

Universal rule 5 is an action applying to nothing.
Understand "lightsplease420" as universal rule 5.
Carry out universal rule 5: now all rooms are lit.
Report universal rule 5: say "Let there be light!"

Universal rule 6 is an action applying to nothing.
Understand "sorrynotsorry" as universal rule 6.
Carry out universal rule 6: now the dog is content.
Report universal rule 6: say "That's such a stupid phrase."

Universal rule 7 is an action applying to nothing.
Understand "secretofmana" as universal rule 7.
Carry out universal rule 7: now the white wyvern is content.
Report universal rule 7: say "Have you ever played it?"

Universal rule 8 is an action applying to nothing.
Understand "takingnotes" as universal rule 8.
Carry out universal rule 8: now the player is carrying Note #1;
now the player is carrying Note #2;
now the player is carrying Note #3;
now the player is carrying Note #4;
now the player is carrying Note #6;
now the player is carrying Note #7;
now the player is carrying Note #8;
now the player is carrying Note #9.
Report universal rule 8: say "Gotta read 'em all!"

Universal rule 9 is an action applying to nothing.
Understand "ruinthefun" as universal rule 9.
Carry out universal rule 9: now the player is carrying the Excalibur;
now the player is in the Arena.
Report universal rule 9: say "Thou art has doth ruin thee fun."

The Excalibur is a thing.

Hitting it with is an action applying to two things.
Understand "hit [a man] with [something]" as hitting it with.

After hitting the doppleganger with the Excalibur:
	say "Doppleganger: 'YoU sUck ChEeEeEEEeEEEeeeaAAaaAaaatTTtttTTTteeRr!'";
	now the doppleganger is nowhere;
	now the left hand status line is "";
	now the printed name of the Arena is "???";
	now the description of the Arena is " ";
	now the dog is in the Arena;
	now the printed name of the dog is "Australian Shepherd";
	now the dog is quiet;
	now the description of the dog is "(Take the book.)";
	wait for any key;
	say "[bold type]BOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOM!!!1!1![roman type]";
	wait for any key;
	clear only the main screen;
	now the reversed book is in the Arena.

Shitting is an action applying to nothing.
Understand "shit", "poop", and "#2" as shitting.
Instead of shitting:
	say "[one of]Let's not do that.[or]If you need to go, go to a toilet already.[or]That's just...[or]Oh my god.[or]You know, if your using this command in the game it's proof that your cheating.[at random]".
Instead of shitting when the player is on a toilet:
	say "Why did I make this a command?"

Section 1.0 - The First Floor

[Living Room - "Happiness dies when you get older. It's a fact."]
The Living Room is a room. The description of the Living Room is "The first room you enter is the living room. It is nothing more than your standard living room. In here are two couches, one chair, a flight of staircases to go up to, a table with a chest on it, and an old television, and also the front door you came in from but that doesn't matter anymore. The place looks beautiful."

The large couch, a small couch, a white chair, a large window, an old television and a coffee table are in the Living Room.
The small chest is on the coffee table. A small chest is a closed openable container. The small chest is fixed in place.
A blue key is in the small chest.
The old television is scenery.
Understand "couch 1" and "sofa 1" as large couch. Understand "couch 2" and "sofa 2" as small couch.

The description of the coffee table is "An simple table to place your coffee and household items on. Looks sturdy."
The description of the large couch is "A red couch that can fit three or more people at once (mostly three, it gets too crowded)."
The description of the small couch is " A red couch that can fit two or more people at once. It's slightly inferior to its larger brother."
The description of the white chair is "A cushioned chair."
The description of the old television is "An old box TV. It's broken though so you can't turn it on and watch 'Game of Thrones.' How disappointing."
The description of the blue key is "A blue key that unlocks something small and clear."
The description of the large window is "Through the window you see your car you drove to get here and some bushes that are alongside the edge of the house. The trees in the distance cover up most of the view but are still pretty to look at."

Instead of switching on the old television:
	say "I said the TV was broken. Don't even try to turn it on. It's hopeless."
After touching the old television:
	say "What's that going to solve?"
After touching the old television for the tenth time:
	end the story saying "The TV somehow managed to turn on after poking it uncontrollably. Are you a wizard or something? Anyways, you decided to sit on the couch and binge watch 'Stranger Things' instead of doing you job. You never left that spot and died of malnutrition. Maybe next time you should think twice before trying to do the inevitable and delaying the other, and also go outside and enjoy the sunlight."

Section 1.1 - The Exit Door

[Exit Door - "She sometimes wish she wasn't a parent"]
The front door is a locked door. It is south of the Living Room. Through it is the Coward Ending.
The exit key unlocks the front door.

After examining the front door the first time:
	say "You can't leave now you just got here."
After examining the front door the second time:
	say "Are you saying you don't want to do this anymore?"
After examining the front door the third time:
	say "Can't you just at least look around before leaving?"
After examining the front door the fourth time:
	say "Look, I know this place may looking intimidating but I assure you it's not that bad. Trust me."
After examining the front door the fifth time:
	say "Please?"
After examining the front door the sixth time:
	say "..."
After examining the front door the seventh time:
	say "Fine! I'll let you leave, but only because I just want you to stop staring at the door like a sad puppy. The key is on that table there. Just take it and leave.";
	now the exit key is on the coffee table.
After entering the front door:
	end the story saying "Wuss."
Instead of going south from the Living Room:
	say "You can't go south."
[Editor's Note: Going south would not end the game so the option in this room was disabled. Type "enter door" instead.]

Instead of examining the front door when the player is carrying the dog:
	say "No turning back now."

[Dining Room - "People tell me I need to gain weight. I can't, my body just can't."]
The Dining Room is east of the Living Room. The description of the Dining Room is "A perfect place to chat and enjoy some delicious food. It's also decorated with fancy china and antique knick-knacks for good looks."

5 chairs are in the Dining Room.
The large table and a computer are in the Dining Room.
The strange meal is on the large table.
The strange meal is edible.
The computer is a switched off device. The computer is fixed in place.
Understand "food" and "grub" as strange meal. Understand "pc" and "desktop" as computer.

The description of the computer is "An old Windows Vista computer... Eww Vista?! Who uses Vista? It was terrible for an Operating System at the time. Whatever."
The description of the strange meal is "A randomly served dish that was left here. It looks tasty but I'd rather not eat it. Who knows how long that's been there for."

Instead of switching on the computer:
	say "There's no time for that right now. What were you gonna search for anyways, sicko?"
Before taking the strange meal:
	say "Are you sure about this? This could be over the expiration date."
Before eating the strange meal:
	say "Eat this abomination?";
	if player consents, end the story saying "You ate the meal and died from food poisoning soon afterwards. Nice job genius.";
	otherwise stop the action.

[Kitchen - "Why can't he just have some self control?"]
The Kitchen is north of the Dining Room. The description of the Kitchen is "Ah yes. The place where all the food is hoarded... I mean stored for winter. Wait, that doesn't make any sense; animals don't live in people homes, or do they? Either way there must be something useful in here."

The dog, a duel sink, a sturdy stool, a stinkbug, a ceiling lamp, the counter-top, a glass cutting board, a coffee machine, a drinking glass, the window sill, and a cupboard are in the Kitchen.
The stinkbug is an animal.
The duel sink, ceiling lamp, counter-top, coffee machine, window sill, drinking glass, and glass cutting board are scenery.
The cupboard is a transparent closed locked openable container. The cupboard is fixed in place. 
The butcher's knife is in the cupboard. The blue key unlocks the cupboard.
Understand "mutt", "hound", "canine", "k9", "pup", and "pooch" as dog.

The description of the dog is "The mutt is [state] and sleeping soundly."
The description of the duel sink is "Incase you're thirsty and need a quick drink."
The description of the cupboard is "A small cupboard. Perfect for encasing small figurines, like toy Indians and soldiers."
The description of the butcher's knife is "It'd be careful when handling that thing if I were you."
The description of the sturdy stool is "This is a very sturdy stool."
The description of the coffee machine is "Coffee: I drink it to forgot but I always remember."
The description of the stinkbug is "Connecticut's cockroaches. If one was to kill it, it would unleash its deadly radiation and permeate throughout the room. Your sister would always freak out when one was in her room even though they did absolutely nothing but fly around and sound like a helicopter and she would ask you kindly to throw it outside and you did. (So many stinkbugs.)"

After switching on the sink for the first time:
	say "The water flows from the faucet. You should turn it off before leaving so you don't waste the water bill, that is if this place is still owned by someone."
Instead of taking the stinkbug for the first time:
	say "You tried to grab it but it flies off somewhere else. Must be one of those frisky kinds."
Instead of taking the stinkbug:
	say "It flies off to another location."
Before attacking the stinkbug:
	say "Kill this pest? (Don't you dare!)";
	if player consents, end the story saying "A heaping amount of Plutonium gas came out of the bug, causing you suffocate and get radiation poisoning at the same time. All those times tossing 5,286 stinkbugs out the window and yet you still forgot not to squish one. Bravo.";
	otherwise stop the action.

[The stinkbugs movement - "No matter how hard I try I can't please them enough."]
Every turn when examining the stinkbug:
	say "The stinkbug is on the [one of]cupboard[or]duel sink[or]ceiling lamp[or]counter-top[or]glass cutting board[or]drinking glass[or]window sill[or]coffee machine[at random]."

Every turn when taking the stinkbug:
	say "Now it's on the [one of]cupboard[or]duel sink[or]ceiling lamp[or]counter-top[or]glass cutting board[or]drinking glass[or]window sill[or]coffee machine[at random]."

[Mudroom - "I've had enough of her stupid sarcasm."]
The Mudroom is north of the Kitchen. The description of the Mudroom is "This is where people place their shoes to prevent dirt from entering the house, hence the name 'mudroom,' and is a convenient place for storing some tools. The room is filled with plants and gardening supplies, must be because of all the windows. The light feels good on the face."

9 windows are in the Mudroom.
A broom-closet is in the Mudroom.
The broom-closet is a locked enterable container. The broom-closet is scenery.
The printed name of the broom-closet is "broom closet".
Understand "broom closet" as broom-closet.

The description of the windows are "Through the windows you can see the backyard. The door to the yard is to the right of you."

Instead of opening the broom-closet:
	say "It's locked and also broken."
Instead of entering the broom-closet:
	say "Remember what happened to Stanley? Do you want to end up like him as well? I don't think so."

Section 1.2 - The Back Door

[Back Door - "She thinks I was the favorite child. She's wrong."]
The back door is a locked door. It is outside of the Mudroom and inside of the Backyard. The butcher's knife unlocks the back door.

The description of the back door is "This door leads to the backyard. Chains are keeping the door barricaded; they look rusty and worn out."

After unlocking the back door with the butcher's knife when the dog is tame:
	say "The chains fell down with a loud clank.";
	now the dog is calm;
	now the description of the dog is "The dog is [state] and awake. It seems to not care about you trespassing the place.";
	now the description of the back door is "This door leads to the backyard. The chains are gone now.";
	now the description of the Kitchen is "As you walk back into the kitchen you almost trip over the dog. The fact of this dog always being near the doorway reminds you of your pet dog Louie. He would always block the doorway to the kitchen because everyone in the house would be hanging out there and he would follow you around for affection. This may not be the last time this happens to you."

After unlocking the back door with the butcher's knife when the dog is startled:
	say "The chains fell down with a loud clank.";
	now the dog is skiddish;
	now the description of the dog is "The dog looks at you all [state] because of your action earlier. Perhaps you should apologize sooner or later so you don't feel guilty about yourself.";
	now the description of the back door is "This door leads to the backyard. The chains are gone now.";
	now the description of the Kitchen is "As you walk back into the kitchen you almost trip over the dog. The fact of this dog always being near the doorway reminds you of your pet dog Louie. He would always block the doorway to the kitchen because everyone in the house would be hanging out there and he would follow you around for affection. This may not be the last time this happens to you.".

[Redemption 1 - "I feel like I'm being rejected by every company."]
After saying sorry to the dog when the dog is startled:
	say "Good! Don't ever do that again.";
	now the dog is tame;
	now the description of the dog is "The dog is [state]. He sits there feeling grateful for your apology."

[Backyard - "Just when I know what to do they persuade me into other careers."]
The description of the Backyard is "The backyard is wide and lush with green grass. It's been bordered with a wooden fence to prevent things for entering or leaving (like you). There's not much to do here besides looks at the clouds, listening to the birds, and enjoying nature at its finest."

The dirt is in the Backyard. The dirt is scenery.
Understand "soil" and "earth" as dirt.

The description of the dirt is "It's dirt. Nuff said."

[Hallway - "I have a tendency to make piss-poor decisions."]
The Hallway is west of the Kitchen and north of the Living Room. The description of the Hallway is "On the hallway walls are a bunch of small picture frames with pictures of people who you don't recognize. Some shelves and drawers can be found here and there with books and other little trinkets on them. This room is mainly for easier transportation between other rooms. Other than that this is just a nice scenic route to take so carry on."

The drawers, the books, the photos and the shelves are scenery in the Hallway.
Understand "pictures" and "photographs" as photos.

The description of the shelves is "Worn out and made of wood. Very dusty as well. [italic type]*cough*[roman type]".
The description of the books is "Nothing peaks your interest. Most of them are about gardening, hiking, and old folk tales."
The description of the drawers is "The drawers are glued together; the books are too. Who does that? Someone must not want you tampering with their stuff."
The description of the photos is "Various faces of unrelated family members. One however catches your eye. A small boy in a vest. You've never seen this boy before and yet he looks familiar to you."

[Bathroom - "She works too much."]
The Bathroom is north of the Hallway. The description of the Bathroom is "A place to bathe and do your business in privacy. The tub, toilet, and sink look clean despite not being used in years."

The medicine cabinet, a fancy toilet, a bathtub, and a small sink are in the Bathroom.
The small sink is scenery. 
After entering the fancy toilet: 
	say "Great...";
	wait for any key;
	say "but you don't need to go."
The bathtub is a enterable supporter. 
After entering the bathtub: 
	say "A perfect fit...";
	wait for any key;
	say "but you're already clean."
The medicine cabinet is a opaque closed openable container. A bottle of red pills and a bottle of blue pills are in the medicine cabinet. The medicine cabinet is fixed in place.
The bottle of red pills and bottle of blue pills are edible.
Understand "pills 1" and "red pills" as bottle of red pills. Understand "pills 3" and "blue pills" as bottle of blue pills. Understand "tub" as bathtub.

The description of the small sink is "A small ornate sink."
The description of the fancy toilet is "The oval office."
The description of the bathtub is "For when you need to wash that filth away."
The description of the medicine cabinet is "This cabinet stores medicine and other little bathroom tools like toothbrushes. It also has a mirror for you to gaze into, even though it's a bit unclear from all the smudge marks."
The description of the bottle of red pills is "A bottle with red pills in it. You don't know what they do. Perhaps these two bottles are a choice. Choose wisely."
The description of the bottle of blue pills is "A bottle with blue pills in it. You don't know what they do. Perhaps these two bottles are a choice. Choose wisely."

After eating the bottle of red pills:
	end the story saying "After gulping down one of the pills you fell asleep and never woke. Perhaps that wasn't the right choice."
After eating the bottle of blue pills:
	end the story saying "After swallowing down one of the pills you woke up in your dream and realized it was just a dream, or was it?"

[Bedroom - "People tell me to be see the positive in things. Those people are assholes."]
The Bedroom is west of the Hallway. The description of the Bedroom is "This where most of the actions happens (that's what she said). You can sleep here, watch some television, or just relax and wind down as time flies by. But there's no time for that you have a mission to still fulfill. Find some clues if you can. There's a clock here but it's broken so that won't help."

The small television, a queen-size bed, a closet, an antique clock, and a wardrobe is in the Bedroom.
The small television is fixed in place. 
After entering the bed: 
	say "Nice and cozy."
The antique clock is scenery.
The closet is an openable enterable closed container. It is fixed in place.
The wardrobe is an openable closed container. It is fixed in place. A red pinned hat is in the wardrobe. The red pinned hat is wearable.
Understand "armoire" as wardrobe.

The description of the small television is "This one is smaller than the one in the living room but unlike that one this one turns on."
The description of the queen-size bed is " A bed fit for two people. When you were little, you remembered climbing into your parents bed when you had nightmares."
The description of the antique clock is "An old clock. The time is off by 3 hours."
The description of the closet is "Just a closet. Nothing special."
The description of the wardrobe is "A portable closet that hangs clothes and possibly leads to Narnia, if you look inside."
The description of the red pinned hat is "A hat with a pin that say 'The stairway to heaven is open.' What could that mean?"

After entering the closet for the first time:
	say "Annnnnnnnd...";
	wait for any key;
	say "it's empty."
After entering the closet:
	say "Nope. Still empty."
After entering the closet for the fifth time:
	say "What, you think something is going to happen if you keep repeatedly going through the closet and get another bad ending or cheesy death so you can tell you're friends, '[italic type]Oh! Did you get the broom closet ending? The broom closet ending was my favorite.[roman type]' Sorry, you're thinking of the wrong game. Come to think of it I believe the actual broom closet in the mudroom is locked and broken. Anyways, get out of that closet.";
	now the description of the broom-closet is "Yep, it's broken alright and also locked.";
	now the description of the closet is "Seriously, stop going in and out of that closet. Your achieving nothing doing this.";
	now the inverted closet is in the Inverted Bedroom.
After entering the closet for the sixth time:
	say "Seriously, stop this."
After entering the closet for the seventh time:
	say "Stop."
After entering the closet for the eighth time:
	say "Come on."
After entering the closet for the ninth time:
	say "Knock it off!"
After entering the closet for the tenth time:
	say "..."
After entering the closet for the eleventh time:
	say "!!!"
After entering the closet for the 12th time:
	say "[bold type]ENOUGH!!![roman type]";
	say line break;
After entering the closet for the 13th time:
	say "You know what I'll do. I'll just end your game here. Yeah, that's right; I can do that.";
	wait for any key;
	say "Watch me!";
	fake command;
	say paragraph break;
	say "  *** Game Over. ***";
	say paragraph break;
	say "Would you like to RESTART, RESTORE a saved game, QUIT or UNDO the last command?"
After entering the closet for the 14th time:
	say "..."
After entering the closet for the 15th time:
	say "I bet your thought your game was over huh? Are you mad about it?";
	if player consents, say "Well maybe you should stop going into the closet over and over again.";
	otherwise say "No! So you didn't fall for my trap?"
After entering the closet for the 16th time:
	say "...";
	wait for any key;
	say "I hate you so much right now."
After entering the closet for the 17th time:
	say "Why won't you just let me have fun for once?"
After entering the closet for the 18th time:
	say "[italic type]groan[roman type]";
	say line break;
After entering the closet for the 19th time:
	say "..."
After entering the closet for the 20th time:
	say "[bold type]STOOOOOOOOOOOOP!!!![roman type]";
	say paragraph break;
	wait for any key;
	say "That's it! I'm done, I'm just... done.";
	wait for any key;
	say "You win, OK?";
	wait for any key;
	say "I don't care anymore. I'll just wait here until you decide to stop lallygagging and make some better use of your time.";
	wait for any key;
	say "Just... please.";
	wait for any key;
	say "Get out of that damn closet soon.";
	now the description of the closet is "Your new home apparently."
After entering the closet more than 20 times:
	say "..."
After entering the closet for the 50th time:
	say "You know what, I just realized the fact that after every death and game over you've obtained throughout this entire game...";
	wait for any key;
	say "doesn't even matter.";
	wait for any key;
	say "In fact, death doesn't even matter to you. Why?";
	wait for any key;
	say "Because you can just simply look at your watch and say 'RESTART' or 'UNDO' and [italic type]boom[roman type] your back where you left off.";
	wait for any key;
	say "As if nothing bad ever happened to you.";
	wait for any key;
	say "Your lucky player. Your lucky that you are always given another chance to try again.";
	wait for any key;
	say "To right the wrong. To fix the broken. To start anew.";
	wait for any key;
	say "Many people wish they had that power in real life.";
	wait for any key;
	say "To fix the mistakes that which they wished they didn't make in the first place.";
	wait for any key;
	say "But you... player, have that power.";
	wait for any key;
	say "You should be grateful that you have this wonderful gift of rewinding time.";
	wait for any key;
	say "I don't care if you keep going in and out this closet still, that's your choice whether you choose to stop or not.";
	wait for any key;
	say "You have freewill to do whatever you want and you should do what you think is best for you.";
	wait for any key;
	say "...";
	wait for any key;
	say "I'll let go now.";
	wait for any key;
	say "But just remember...";
	fake command 2;
	say "Always."
After switching on the small television:
	say "The TV only shows static. Must have poor signal, just like the college you attended. You'll never miss that."
After switching off the small television:
	say "The TV cuts to black."
After wearing the red pinned hat:
	say "As you put on the hat, a strange noise is made. It came from the Living Room."

[Prevent wearing two hats at once - "I'm more of an optimistic pessimist."]
Instead of wearing the red pinned hat:
	if the player is wearing the black cap, say "You'll need to take off your other hat first.";
	otherwise continue the action.

Instead of wearing the black cap:
	if the player is wearing the red pinned hat, say "You'll need to take off your other hat first.";
	otherwise continue the action.

Section 1.3 - The Upstairs

[Prevent going upstairs without an equipped item - "Elementary was a nightmare."]
Instead of going up from the Living Room: 
	if the player is wearing the red pinned hat, continue the action;
	otherwise say "Something is blocking you from going upstairs."

Section 2.0 - The Second Floor

[Second Floor Room - "They always told me I was 'special,' but am I really?"]
The Second Floor is up from the Living Room. The description of the Second Floor is "A small room that corners into four doorways. North is the bathroom, East is the Master Bedroom (which is locked so you can't go that way yet), West is the Guest Bedroom, and South is back down the stairs. Choose a destination. (Note: Going south leads nowhere, type 'down' instead.)"

[Upstairs Bathroom - "He doesn't take criticism well."]
The Upstairs Bathroom is north of the Second Floor. The description of the Upstairs Bathroom is "This bathroom is small than the one downstairs. It contains no bathtub but does have a toilet and sink at least. Most of the room is empty besides this mirror hanging above the sink, which is making a weird glow on its reflective surface."

The small toilet, an upstairs window, and a small upstairs sink are in the Upstairs Bathroom.
A ink bottle is on the small toilet.
After entering the small toilet: 
	say "Great...";
	wait for any key;
	say "but you don't need to go."
The small upstairs sink is scenery.

The description of the small toilet is "This toilet is similar to the one downstairs but smaller."
The description of the small upstairs sink is "Same bathroom sink but upstairs. That's all folks."
The description of the ink bottle is "On the bottle is inscribed, 'For making invisible writing visible again.'"
The description of the upstairs window is "Through the window you can see the entire backyard from a higher viewpoint. You can even see over the fence where the woods reside."

[Guest Bedroom - "Life sucks sometimes but I don't believe in suicide being a solution."]
The Guest Bedroom is west of the Second Floor. The description of the Guest Bedroom is "A room used when guests visit. Of course, guests can also sleep in the downstairs bedroom, living room, or where ever there's a couch or bed to sleep on. There's even a rug for a softer luxury. How sweet."

The guest bed, a desk, a small chair, a bureau, and a soft rug are in the Guest Bedroom.
After entering the guest bed:
	say "It's as comfy as the other bed and yet you still don't feel sleepy."
On the desk is the yellow note. It is fixed in place.
The bureau is a supporter. On the bureau is a pot of flowers.
A bureau drawer is part of the bureau. The bureau drawer is a closed openable container.
The soft rug is scenery.
Understand "dresser" as bureau. Understand "dresser drawer" as bureau drawer.

The description of the guest bed is "A small bed fit for one person and one person only."
The description of the desk is "Perfect of writing and doing work on, like homework. You always hated doing homework for school."
The description of the small chair is "A nice wooden chair to sit in while doing work at your desk."
The description of the bureau is "Used to store clothing in. This reminds you of times you went panty raiding with your friends in high school. You sick pervert you."
The description of the soft rug is "Good thing you took your shoes off before you came into the house. You would have gotten dirt all over it. It feels nice on your feet."
The description of the pot of flowers is "Flowers: they make the room look alive. These flowers, however, are lacking sunlight and need a spot on the east side where the light beckons."
The description of the yellow note is "Using the ink bottle on the note revealed a hidden message. On the note reads, 'RGB. The middle one is the correct one to consume.'"

Instead of opening the bureau drawer:
	say "It's locked tight. Good on them."
After smelling the pot of flowers:
	say "Mmm... what a nice aroma it gives off."
After taking the pot of flowers:
	say "This could be helpful one day."

[Prevent reading note unless player has key item - "We never saw eye to eye."]
Instead of examining the yellow note:
	if the player is carrying the ink bottle, continue the action;
	otherwise say "There's nothing written on this note."

[Pills action - "I regret nothing."]
After examining the yellow note for the first time:
	say "Hmm...";
	now the bottle of green pills is in the medicine cabinet.

A bottle of green pills is an edible thing.
Understand "pills 2" and "green pills" as bottle of green pills.

The description of the bottle of green pills is "Were these pills here before?"

[Light switch action - "Some people tell me you need to be more positive. That's just creepy if overdone."]
After eating the bottle of green pills:
	say "After consuming one of the green pills, you hear a noise coming from down below.";
	now the light switch is in the Hallway; now the description of the Hallway is "On the hallway walls are a bunch of small picture frames with pictures of people who you don't recognize. Some shelves and drawers can be found here and there with books and other little trinkets on them. This room is mainly for easier transportation between other rooms. You notice that there's a switch now on the wall. Was it here before and you didn't notice it until now?"

A light switch is a device. It is fixed in place.

Carry out switching on the light switch:
	now the Basement is lit.

Instead of switching off the light switch:
	say "The switch is now stuck in its position. It cannot be turned off."

Section 2.1 - The Downstairs

[Prevent moving forward in the dark - "Sometimes you need to be upset. It's what makes us human."]
Instead of going south from the Basement:
	if the light switch is switched on, continue the action;
	otherwise say "You can't move anywhere until you find some sort of light source."

Instead of going west from the Basement:
	if the light switch is switched on, continue the action;
	otherwise say "You can't move anywhere until you find some sort of light source."

Section 3.0 - The Lower Floor

[Basement - "Why am I like this?"]
The Basement is down from the Hallway. The Basement is dark. The description of the Basement is "A musky place this is. There's a lot of junk down here, it must have been used for storage mostly. Kind of reminds you of your basement back home; all cluttered and full of boxes and stuff. There's only two rooms down here, one being a cellar and the other being the back room. Maybe somewhere in all this junk is something useful."

A refrigerator, a washer, a dryer, a junk pile, a circuit breaker, and a large box are in the Basement.

The refrigerator is an closed openable container. It is fixed in place.
The refrigerator can be cold. The refrigerator is cold.
The washer and dryer are a openable container. The washer and dryer are fixed in place.
The junk pile is scenery.
The circuit breaker is a switched on device. It is fixed in place.
The large box is a closed openable container. It is fixed in place.
Inside the box is a clown doll. The clown doll is fixed in place.
Understand "fridge" as refrigerator.

The description of the refrigerator is "It's a device that contains food and conserves it at a reason temperature. People would often misspell 'refrigerator' with a 'D' because everyone says fridge mostly. College was no different either with you and your peers misspelling it over and over again. In the end, you decided to not even bother trying to spell it correctly and said fridge instead. Same goes with other words like 'television as tv' and 'telephone as phone.' So many 'tele's' have been removed, am I right?"
The description of the washer is "A machine that washes."
The description of the dryer is "A machine that dries."
The description of the junk pile is "Stop looking at my junk! (And get your mind out of the gutters too!)"
The description of the circuit breaker is "This is the main power supply of the entire house. Without it, nothing will work. So don't touch it if you know what's good for ya."
The description of the large box is "A cardboard box."
The description of the clown doll is "Devil incarnate."

After opening the large box for the first time:
	say "BAH!";
	wait for any key;
	say "A clown doll jumps out of the box like a jack-in-the-box and spoops you. The fact that your biggest fear is clowns doesn't make this situation any better; especially that weird news about people going around wearing clown masks at night you heard once did not help your anxiety either.";
	say line break;
	wait for any key;
	say "And yes I said 'spoop,' problem?"
After closing the large box:
	say "Thank goodness. Let's never open that again."
After opening the large box for the second time:
	if the clown doll is undamaged, end the story saying "Unfortunately for you, the clown managed to make you fall unconscious and die of a heart attack. Great! Now who am I supposed to make fun of now? Maybe that freak with the glowing red nose will make a good substitute victim... I mean player. Yes player that's it, that's what I'll do."
After attacking the clown doll:
	say "Take that, stupid clown! (The box broke along with the clown doll.)";
	now the clown doll is damaged;
	now the clown doll is in the Basement;
	now the large box is nowhere;
	now the description of the clown doll is "Dead incarnate. In your face, Pennyworth!";
	now the evil clown is in the Floating Basement.
After touching the refrigerator:
	say "It's on and cold."

Before switching off the circuit breaker:
	say "Are you sure this is a good plan?";
	if player consents, end the story saying "Turning off the breaker has caused the whole place to black out. Now how are we supposed to get anywhere in pitch darkness?";
	otherwise stop the action.

[Cellar - "She thinks my life is easier. I say 'There's no such thing as an easy life.'"]
The Cellar is south of the Basement. The description of the Cellar is "This small-ish room contains a huge amount of supplies. Non-perishable food, wine & alcohol, paper towel & toilet paper, and much more. All the essentials needed for the place. Whoever owns or owned this house must be loaded."

A wine bottle, some paper towels, and some toilet paper are in the Cellar.

The paper towels, and toilet paper are scenery.
The wine bottle is a closed openable container.
Inside the wine bottle is a black orb.

The description of the wine bottle is "Aged and finely made. '[bold type]Grape Vinery INC: Established AD 33[roman type]' ...What?"
The description of the paper towels is "Incase you ever make a spillage and need to clean it up."
The description of the toilet paper is "I don't need to tell you what this does, ok?"
The description of the black orb is "A small orb of mystery."

After opening the wine bottle:
	say "Upon opening the bottle revealed no wine but a strange little black orb inside."

After taking the black orb for the first time:
	say "A loud clunk is made in the Mudroom.";
	now the shovel is in the Mudroom.
	A shovel is a thing.

Section 3.1 - Domino Effect

[Shovel usage - "I have an irrational ability to say the wrong answer too quickly, which sometimes will turn into an accidental lie."]
The description of the shovel is "A tool used for digging or bashing things in the head with."

After digging the dirt with the shovel for the first time:
	say "Buried in the mound of dirt was a coin.";
	now the coin is in the Backyard.
	A coin is a thing.

[Coin usage - "I also take too long to answer. Why is my brain so hypocritical?"]
The description of the coin is "A gold coin that has writing inscribed on it saying, 'I need light to grow big and strong.'"

After examining the coin when the dog is calm:
	now the dog is on the large couch;
	now the dog is chill;
	now the description of the dog is "The dog lays comfortably on the couch.";
	now the description of the Living Room is "As you walk back into the living room you find the dog resting in the sunlight on the large red couch. Your dog usually likes doing that because he enjoys the sun on his body. You called it his sunspot.";
	now the description of the Kitchen is "The dog is nowhere to be spotted. Must have moved somewhere else.";
	now the sunlight is in the Dining Room;
	now the description of the Dining Room is "A perfect place to chat and enjoy some delicious food. It's also decorated with fancy china and antique knick-knacks for good looks. Sunlight from the window is now shining into the room."

After examining the coin when the dog is skiddish:
	now the dog is on the large couch;
	now the dog is upset;
	now the description of the dog is "The dog lays comfortably on the couch.";
	now the description of the Living Room is "As you walk back into the living room you find the dog resting in the sunlight on the large red couch. Your dog usually likes doing that because he enjoys the sun on his body. You called it his sunspot.";
	now the description of the Kitchen is "The dog is nowhere to be spotted. Must have moved somewhere else.";
	now the sunlight is in the Dining Room;
	now the description of the Dining Room is "A perfect place to chat and enjoy some delicious food. It's also decorated with fancy china and antique knick-knacks for good looks. Sunlight from the window is now shining into the room."

[Optional dog scene - "How did I get this far?"]
Before entering the large couch when the dog is upset:
	if the dog is on the large couch, say "The dog will not let you sit down. He is still upset at you. Maybe this is your chance to apologize."; stop the action.

Before entering the large couch when the dog is chill for the first time:
	if the dog is on the large couch, say "You sit next to the dog and enjoy the sunlight together. He really enjoys your company. Upon further inspection of the dog you find a note that reads:";
	say paragraph break;
	wait for any key;
	say "'[italic type]Don't take the book. The real book is somewhere else, but you can't get to it because the item you need is invisible. Examine the Master's room for a green chest. Inside this chest you will find something that will help you reach the real book. For now, play the game normally until you reach this part of the game. Good luck player![roman type]'";
	say paragraph break;
	wait for any key;
	say "What?";
	wait for any key;
	say "";
	continue the action.

After entering the large couch when the dog is chill for the first time:
	wait for any key;
	say "...this couch is comfy by the way."

[Redemption 2 - "This world is many things."]
After saying sorry to the dog when the dog is skiddish:
	say "The dog forgives you. Now you feel better about yourself as a being.";
	now the dog is calm;
	now the description of the dog is "The dog is [state]. Good dog."

[Redemption 3 - "I don't hate."]
After saying sorry to the dog when the dog is upset:
	say "The dog forgives you. Now you can sit down as long as you behave yourself.";
	now the dog is chill;
	now the description of the dog is "The dog is [state]. Good dog."

[Flowers usage - "They dislike me saying things about them, even in my head."]
The sunlight is scenery.

Before putting the pot of flowers on the large table:
	if the sunlight is in the Dining Room, continue the action;
	otherwise say "Nothing happens."; stop the action.

After putting the pot of flowers on the large table:
	say "The flowers lean towards the sunlight and dance with glee.";
	now the pot of flowers are fixed in place;
	now the description of the pot of flowers is "The flowers are in a joyful bloom.";
	now the clothes pile is in the Basement;
	now the description of the Basement is "Most of the boxes and junk have moved towards the walls, leaving some more room to walk around in. Something must have happened here while you were doing other things."
	The clothes pile is a thing.

[Clothes usage - "She's always annoyed of asking us to do things. Well, that's life. You can't escape it."]
The description of the clothes pile is "A pile of clothes that needs a good washing."

After inserting the clothes pile into the washer:
	say "You put the clothes in the washer, now close it up."

Instead of inserting the clothes pile into the dryer:
	say "Wrong place."

Instead of closing the washer:
	if the clothes pile is in the washer, continue the action;
	otherwise say "Not yet."; stop the action.

After closing the washer:
	say "You closed the lid and turned it on. Now what? Hey, what's that on the fridge.";
	now the washer is closed;
	now the washer is locked;
	now the description of the refrigerator is "A note on the fridge reads, 'Confucius says: Good things come to those who wait.'"

Before waiting:
	if the clothes pile is in the washer, continue the action;
	otherwise say "Don't waste any precious time."; stop the action.

After waiting:
	say "Time passes. The clothes are done and in that basket here.";
	now the wet clothes pile is in the wicker basket;
	now the wicker basket is in the Basement;
	now the clothes pile is nowhere;
	now the description of the Basement is "Nothing else mysterious has happened while you were waiting for the clothes to finish washing. This basket, on the other hand, has magically appeared with the soaking wet clothes you put in the washer. You didn't even need to open it. Not that you needed to since it cannot be a container and a device at the same time."
	The wet clothes pile is a thing.
	The wicker basket is a open container. It is fixed in place.

[Wet clothes usage - "At least I try. Is that any better for you?"]
The description of the wet clothes pile is "The clothes pile is wet and needs some hot air."
The description of the wicker basket is "A hand-weaved basket made of thin wooden twigs. Very sturdy and perfect for clothing."

After inserting the wet clothes pile into the dryer:
	say "You put the clothes in the dryer, now close it up too."

Instead of inserting the wet clothes pile into the washer:
	say "This clothes pile is already soaked."

Instead of closing the dryer:
	if the wet clothes pile is in the dryer, continue the action;
	otherwise say "Not yet."; stop the action.

After closing the dryer:
	say "You closed the lid and turned it on. Good job! You did someone else's laundry. How nice of you to do.";
	wait for any key;
	say "Here, have a cookie for your hard work. You earned it.";
	now the dryer is locked;
	now the dryer is closed;
	now the player is carrying a cookie;
	now the description of the Basement is "You feel proud of yourself for once. I'm sure your mother would feel the same. Speaking of mother, when was the last time you called her?"
	The cookie is edible.

[Reward - "I don't need your pity."]
The description of the cookie is "Snickerdoodle: My favorite."

After eating the cookie:
	say "Eating the cookie has given you the motivation you needed to strive on forward. Now check the fridge.";
	now the giant egg is in the refrigerator;
	now the platform is in the Mudroom;
	now the description of the Mudroom is "A strange platform has appeared unexpectedly in this room. Let's check it out."
	The giant egg is a thing.
	The platform is a supporter.

[Egg task - "I sometimes wish rebirth was a thing."]
The description of the giant egg is "An unusually sized egg that has a funky pattern on its shell. You've never seen one this big and beautiful before."
The description of the platform is "On the platform is inscribed 'Put the egg hear and come back later on the other side.' What does it mean by 'other side.'"

After taking the giant egg:
	say "Yeesh... this is heavy.";
	now the refrigerator is closed.

After putting the giant egg on the platform:
	say "Once you set the egg down gently on the platform, light shined upon it. Shortly afterwards, a noise was made in the Bedroom.";
	now the giant egg is fixed in place;
	now the description of the Mudroom is "The egg you placed now stands there as a decoration. The platform told you to come back later, as in some other place that is not here but where you ask yourself. That sentence gives you a chill down your spine for some unexplained reason.";
	now the description of the Bedroom is "There's something hanging on the wall.";
	now the backpack is in the Bedroom.
	The backpack is a wearable container.
	Inside the backpack is a crowbar.

Instead of eating the giant egg:
	say "That might not be very nutritious.";
	wait for any key;
	say "You don't even have anything to cook it with, but why would you want to do that?";
	wait for any key;
	say "You don't know what's even inside the egg.";
	wait for any key;
	say "Plus I'm curious, so no eating it. Capiche?"

Section 3.2 - End of the Effect

[The backpack & dog - "I am independent, but also not."]
The description of the backpack is "Used for carrying things and wearing on your back for convenience. It's not just used for school either or your back."
The description of the crowbar is "A popular weapon of choice."

After wearing the backpack when the dog is chill:
	say "As you put on the backpack a small earthquake happens. The dog runs into the room with you blocking the doorway out.";
	now the description of the Bedroom is "Take him with you.";
	now the dog is in the Bedroom;
	now the dog is content;
	now the description of the dog is "He looks agonized as all else. He looks up at you expecting you to take him. Maybe you should.";
	now the description of the Living Room is "It's quiet and empty in here now.";
	now the description of the Backroom is "Most of the boxes feel over from the earthquake. They are at your reach now but nothing in them are of use to you.";
	now the description of the boxes are "Various plastic containers that are filled with a bunch of holiday decorations. They are all over the floor now.";
	now the description of the photos is "That boy. Why is he so... familiar to you. Maybe you have seen him before... but where?"

After wearing the backpack when the dog is upset:
	say "As you put on the backpack a small earthquake happens. The dog runs into the room with you blocking the doorway out.";
	now the description of the Bedroom is "Take him with you.";
	now the dog is in the Bedroom;
	now the dog is stubborn;
	now the description of the dog is "He looks agonized as all else. He wants you to take him, but not until you say your sorry first.";
	now the description of the Living Room is "It's quiet and empty in here now.";
	now the description of the Backroom is "Most of the boxes feel over from the earthquake. They are at your reach now but nothing in them are of use to you.";
	now the description of the boxes are "Various plastic containers that are filled with a bunch of holiday decorations. They are all over the floor now.";
	now the description of the photos is "That boy. Why is he so... familiar to you. Maybe you have seen him before... but where?"

Before taking the dog when the dog is content:
	if the dog is in the Bedroom, say "You put him in the backpack. Now you can move on. Get the key in the back room of the basement and head for the Master Bedroom.";
	now the description of the Bedroom is "Having the dog with you makes you feel less isolated.";
	now the description of the Kitchen is "The dog is with you.";
	now the printed name of the dog is "Australian Shepherd - Status: [state]";
	now the description of the dog is "He seems [state].";
	continue the action.

Before taking the dog when the dog is stubborn:
	if the dog is in the Bedroom, say "You've waited long enough. Say it.";
	stop the action.

[Final Redemption - "Maybe I'm not as smart as I my mother thought I was."]
After saying sorry to the dog when the dog is stubborn:
	say "Great! Now he's satisfied.";
	now the dog is content;
	now the description of the dog is "He's waiting for your response."

[Prevent leaving until dog is taken - "My mistakes only tick them off even more."]
Instead of going east from the Bedroom when the dog is in the Bedroom:
	if the player is carrying the dog, continue the action;
	otherwise say "Looks like you have no choice but to take him with you."

[DOG: Spell that backwards - "If there is a god, why isn't anything getter better? Answer me that."]
Instead of dropping the dog:
	say "You can't."

Instead of inserting the dog into the backpack:
	if the player is carrying the dog, say "You're already carrying him.";
	otherwise say "Type 'take dog' instead."

Instead of taking off the backpack:
	say "No."

[Prevent taking dog early - "Time management, multitasking, priority, common sense, comprehension. They all need improvement."]
Instead of taking the dog:
	if the dog is in the Bedroom, continue the action;
	otherwise say "He doesn't feel like it right now."

[Backroom - "I have to fix things, otherwise the voices won't stop."]
The Backroom is west of the Basement. The description of the Backroom is "More boxes can be found here all stacked up on each other. You won't be able to reach or open most of them because you lack the right tools needed to open them, but they don't seem of importance to you. Most of them are labeled as 'decorations' or 'crafting materials,' none of which are necessary for you."

A trap door and some boxes are in the Backroom.

The trap door is a closed locked container. It is fixed in place.
Inside the trap door is the bedroom key.
The boxes are scenery.

The description of the trap door is "A door used for storing things underneath. It's also used in magic shows and theatre for special effects. The door has been reinforced; you'll need something strong to break it open."
The description of the boxes are "Various plastic containers that are filled with a bunch of holiday decorations. The boxes you have at home in your basement get cluttered up just like these ones. Maybe you should think about having a garage sale and get rid of some of those old decorations you barely use anymore."
The description of the bedroom key is "The key that unlocks the Master Bedroom. Finally."

Section 3.3 - The Last Doors

[Trap Door - "Love?"]
After breaking the trap door with the crowbar for the first time:
	say "The door breaks into pieces. Inside the empty hole reveals the bedroom key.";
	now the trap door is damaged;
	now the trap door is open;
	now the trap door is unlocked;
	now the description of the trap door is "It's has broken into many wooden and metal pieces. It is beyond repairs now."

After breaking the trap door with the crowbar:
	say "That's already broken."

Instead of closing the trap door:
	if the trap door is damaged, say "It's impossible to close the door now that its been destroyed.";
	otherwise say "It's already shut tight."

After taking the bedroom key for the first time:
	say "You hear a soft blow of the wind as you take the key.";
	now the description of the Second Floor is "Unlock the Master Bedroom door.";
	now the description of the bedroom door is "You have the key, now unlock it and go inside."

[Bedroom Door - "I hate being cold? At least I don't complain about heat."]
The bedroom door is a locked door. It is east of the Second Floor and west of the Master Bedroom. The bedroom key unlocks the bedroom door.

The description of the bedroom door is "This door leads to the master's room, but it's locked tightly shut. This person must be hiding something secretive inside. Find the key and then come back here once you've found it."

After unlocking the bedroom door with the bedroom key:
	say "The door makes a [italic type]click[roman type] as you unlock it. You can now enter the Master's Bedroom.";
	now the description of the bedroom door is "The door is unlocked.";
	now the description of the Second Floor is "Go inside. You're almost there."

Section 4.0 - Final Room?

[Master Bedroom - "They hate it when I hide in my sanctuary."]
The description of the Master Bedroom is "This is where the master of the household sleeps in. This is the last room you have yet to check. Could this book here be what you're looking for?"

The pedestal, the master's bed and a recliner chair are in the Master Bedroom.
The pedestal is a supporter. On the pedestal is the book.
The book is a closed openable container.
The printed name of the recliner chair is "recliner".
Understand "recliner" as recliner chair.
Understand "stand" as pedestal.

The description of the book is "A randomly placed book on a small stand. Shall we take it and see?"
The description of the recliner chair is "An ultra comfy chair that has a button that extends the bottom part out as leg rests. Doesn't hurt to give it a try."
The description of the master's bed is "Only the master of the household can sleep here. Of course, he's not here right now. In fact, this house has been quiet, empty, and desolate for some time now. I wonder why. Well, while were thinking about this burning question let's rest."
The description of the pedestal is "A small roman marble column in the shape of a stand. The book sits on top of it like its of great importance."

After entering the master's bed:
	say "Zzzz... soooo soft.";
	wait for any key;
	say "(You're not actually sleeping by the way.)"

After getting off the master's bed:
	say "Ahh, what a nice break that was. Wanna [bold type]save[roman type] your game while your at it? Wouldn't want that angry mole hounding you about not doing it."

After entering the recliner chair:
	say "You sat in the seat and pressed the button on the side. The leg rests pushed out from the front and now you're sitting in style and comfort. Heck yeah!"

After getting off the recliner chair:
	say "Well it was nice while it lasted. You should [bold type]save[roman type] your game just incase."

Section 5.0 - Ending 1

[Taking the book and/or reading it - "My dreams are my only escape out of reality."]
After taking the book for the first time:
	say "Now that you have it, read it.";
	now the description of the book is "...open it up and see."

Before opening the book:
	say "Are you sure?";
	if player consents, continue the action;
	otherwise stop the action.
[Editor's Note: Reading counts as examining so opening the book is the alternative way of ending the game.]

After opening the book:
	say "As you open the book, you skim through the pages. Something seems wrong though.";
	wait for any key;
	say "This book...";
	wait for any key;
	say "...its backwards.";
	wait for any key;
	say "Everything is read backwards.";
	wait for any key;
	say "It even reads backwards, like a manga; from right to left. Could this really have been the artifact you were looking for this whole time?";
	wait for any key;
	say "If so, how would you even know what it says?";
	wait for any key;
	say "";
	say paragraph break;
	wait for any key;
	say "Let's get out of here.";
	wait for any key;
	clear only the main screen;
	now the player is in the Driveway;
	say "As you leave back to your car, with the dog following you back, you reflect back on everything you have done. In the end, was this all a waste?";
	wait for any key;
	say "Probably not. You did your best but I guess you may never know what really happened here at this old barren house in the middle of nowhere.";
	wait for any key;
	say "Though you can't shake the feeling that something was still missing. Whatever it is, it's probably best left unknown.";
	wait for any key;
	now the left hand status line is "Total turns: [turn count]";
	now the right hand status line is "";
	end the story finally saying "[bold type]End Game. Thanks for playing![roman type]".
	The Driveway is a room.

Section 6.0 - The Green Chest

[Green Hope Chest - "I was laughed at. They only liked me because my mother was cool."]
A green hope chest is in the Master Bedroom.
The green hope chest is a closed openable container. The green hope chest is scenery. Inside the green hope chest is a scepter.

The description of the green hope chest is "Wait!"
The description of the scepter is "On the scepter is a message. '...mirror...bathroom...' What a cryptic message."
Understand "rod" and "wand" as scepter.

After examining the green hope chest:
	wait for any key;
	say "...what is that?";
	wait for any key;
	say "...a chest?";
	wait for any key;
	say "...was it here the whole time and we haven't noticed it until now?";
	wait for any key;
	say "...?";
	wait for any key;
	say "...shall we take a look inside?";
	now the description of the green hope is "A large green chest that stores blankets and clothing. You did not see it at first because it was invisible to you, but after examining it closely it appeared visible and clear before your very eyes.";
	now the description of the Master Bedroom is "...";
	now the description of the Second Floor is "..."

After opening the green hope chest:
	say "As soon as you open the chest the book magically disappears into thin air. This must be what that note on the dog meant. Inside the chest lies a scepter.";
	now the book is nowhere.

After taking the scepter:
	say "The minute you took the scepter the house shakes violently, causing a black out to happen for a short bit. The dog barks in fear and when things started to quiet down, you opened your eyes and saw some strange glow emitting outside the room.";
	wait for any key;
	say "";
	say line break;
	wait for any key;
	say "...whatever happens next is beyond me. You should [bold type]save[roman type] while your at it because this adventure ain't over yet.";
	now the dog is scared;
	now the description of the dog is "He's [state] right now from the earthquake.";
	now the description of the Master Bedroom is "The book that was once in here is now gone. Where could it have gone? Somethings telling me that book was not the right artifact. Let's get outta here and find out what to do next.";
	now the description of the pedestal is "It's empty now without the book.";
	now the description of the Second Floor is "The glow is coming from the bathroom here.";
	now the description of the Upstairs Bathroom is "The mirror glows radiantly; the scepter is reacting to the mirror.";
	now the description of the Dining Room is "The food on the table has disappeared.";
	now the strange meal is nowhere;
	now the description of the Mudroom is "Something about this egg feels kind of strange.";
	now the description of the Backyard is "There's no birds chirping outside.";
	now the description of the Hallway is "These pictures...";
	now the description of the Bathroom is "The roof of the bathroom has cracked a bit from the earthquake before.";
	now the description of the Guest Bedroom is "The walls are peeling away.";
	now the description of the Basement is "It feels colder now.";
	now the description of the Cellar is "Phew... the room just got warmer all of a sudden.";
	now the description of the Backroom is "The pipes in the wall have busted through and water is dripping out from the cracks.";
	now the description of the mirror is "A doorway?"

Instead of dropping the scepter:
	say "You can't."

Section 6.1 - The Other Side

[Doorway 1 - "What if they don't like it?"]
The mirror is an open door. It is east of the Upstairs Bathroom and west of the Inverted Upper Bathroom.

Instead of going east from the Upstairs Bathroom:
	if the player is carrying the scepter, continue the action;
	otherwise say "That's not possible."; stop the action.

Section 7.0 - The Mirrored Second Floor

[Inverted Upper Bathroom - "Why does she get a job and I don't? She's younger than me and I'm still trying to find one."]
The description of the Inverted Upper Bathroom is "You held the scepter up to the mirror and it sucked you and the dog inside. What is this place? There's a note here. Let's check it out."
The printed name of the Inverted Upper Bathroom is "???".

A red note is in the Inverted Upper Bathroom. The red note is fixed in place.

The description of the red note is "[italic type]Dear Player,[paragraph break]That mirror that you went into has sent you to a new unexplored world where everything is reversed and things don't appear as they did before. Talk about extreme home renovations, am I right? Be prepared because things are going to get stranger and more difficult from this point on. Before you move on I should tell you this. If at any point you feel unsure of what to expect from this new world, examine the dog every once in a while. I've been told they can see ghosts or something but that may be a myth. Either way, he may tell you something that your not entirely aware of. Also if something tragic ever happens to you the dog will leave. You won't notice it at all because you'd be dead at that point and can't check your inventory but he does leave. (I'm only doing this as an illusion so Peta doesn't come after me for dog slaughter. Also I like dogs.) Finally, you can return back to the original house you came in just incase you feel afraid to move on. Just walk back into the mirror. There's nothing else to do there but that option is open to you. And that's all, I think. Good luck and may the force be with you or whatever.[paragraph break]Yours Truly, -----------------[roman type]".

After examining the red note:
	say "Whose this strange person that keeps writing to you? You probably will never know. Anyways, after reading the note your map was updated to the new layout of the house. Check it out whenever your feeling lost.";
	now the small map is nowhere;
	now the red note is nowhere;
	now the player is carrying the large map;
	now the description of the Inverted Upper Bathroom is "Seeing the bathroom in this dimension gives you goosebumps. That strange note you read doesn't help with the anxiety either but at least it gave you some good advice.";
	now the printed name of the Inverted Upper Bathroom is "Inverted Upper Bathroom";
	now the description of the mirror is "The portal that takes you between two dimensions: The Regular House & The Inverted House. (Whatever you do now, don't say [bold type]M-A-R-Y's[roman type] name.)";
	now the inverted toilet is in the Inverted Upper Bathroom;
	now the inverted sink is in the Inverted Upper Bathroom;
	now the description of the Second Floor is "Where to?";
	now the description of the Upstairs Bathroom is "Screams can be faintly heard from the other side.";
	now the description of the dog is "He has nothing to say about this room."

The description of the inverted sink is "Another sink that looks filthy."
The description of the inverted toilet is "Another toilet. It's seat is heavily trashed and beaten up."
The inverted sink is fixed in place.

After switching on the inverted sink:
	say "A strange black liquid flows through the faucet. I'd rather not even try to drink it. Even the dog wishes you don't."
After entering the inverted toilet:
	say "Still don't need to go."

[Prevent moving forward until note is read - "She told me jealousy is a part of life and you have to learn to earn the thing you wish to achieve."]
Before going south from the Inverted Upper Bathroom:
	if the player is carrying the large map, continue the action;
	otherwise say "Let's read the note first."; stop the action.

[Inverted Second Floor Room - "I'm not angry at anyone. I can only be angry at myself."]
The Inverted Second Floor is south of the Inverted Upper Bathroom. The description of the Inverted Second Floor is "Four ways to go. North - Bathroom, East - First Bedroom, West - Second Bedroom, South downward - downstairs. Which way?"

After going north from the Inverted Second Floor:
	now the dog is content;
	now the description of the dog is "He has nothing to say about this room.";
	continue the action.
After going south from the Inverted Upper Bathroom:
	now the dog is content;
	now the description of the dog is "He asks that you search through the garbage can.";
	continue the action.
After going east from the Anti-Bedroom:
	now the dog is content;
	now the description of the dog is "He asks that you search through the garbage can.";
	continue the action.
After going west from the Trespasser's Bedroom:
	now the dog is content;
	now the description of the dog is "He asks that you search through the garbage can.";
	continue the action.
After going up from the Unliving Room:
	now the dog is content;
	now the description of the dog is "He asks that you search through the garbage can.";
	continue the action.

A garbage can and some writing are in the Inverted Second Floor.
The garbage can is a container. It is fixed in place.
Inside the garbage can is crumbled paper. The crumbled paper is scenery.
The writing is fixed in place.

The description of the garbage can is "There's a bunch of paper in this garbage can."
The description of the writing is "The writing on the wall says,[paragraph break]'Remember: [bold type]Yes[roman type] means [bold type]No[roman type] & [bold type]No[roman type] means [bold type]Yes[roman type] here.'[paragraph break]What does that mean?"

Instead of inserting something into the garbage can:
	say "That's not a good plan."
After searching through the crumbled paper for the first time:
	say "You rummaged through the crumbled up paper and found a perfectly clean note at the bottom.";
	now Note #1 is in the garbage can.

The description of Note #1 is "[italic type]I've been told by the power company my payment is past due. They say if I don't make the payment by the end of the month they will shut me down. I can't let this happen to myself. I wish I could but I don't have enough money in my account yet. Hopefully I'll be able to earn enough by Tuesday, otherwise I don't know what to do with my life's work.[roman type]"

[Anti-Bedroom - "I'm different. Big whoop."]
The Anti-Bedroom is west of the Inverted Second Floor. The description of the Anti-Bedroom is "The once colorful Master's Bedroom is nothing more than a grey, dull room."

After going west from the Inverted Second Floor:
	now the dog is content;
	now the description of the dog is "He wants you to lay on the bed, but why?";
	continue the action.

A broken recliner chair, a wrecked bed, a cracked pedestal, and a busted laptop are in the Anti-Bedroom.
The cracked pedestal is a supporter.
The busted laptop is a switched off device. It is fixed in place.
The printed name of the broken recliner chair is "broken recliner".
Understand "stand" as cracked pedestal. Understand "recliner" as broken recliner chair.

The description of the broken recliner chair is "The chair has many rips and holes. The button that brings out the foot rest is stuck inside. That sucks."
The description of the wrecked bed is "The bed is a messed up. The sheets are torn and ripped and the bed is almost to the point of snapping in half."
The description of the cracked pedestal is "The once ornate pedestal is now slightly chipped in various sides. It's also empty and alone. How sad."
The description of the busted laptop is "It's missing many keys from its keyboard. The ones that are still intact are sticky and won't budge."

After entering the broken recliner chair:
	say "The seat is still comfy but the leg rest is stuck inside. No leg rest for you this time."
Instead of switching on the laptop:
	say "The screen is cracked and the battery is dead. There's no way of turning it on."
Before entering the wrecked bed for the first time:
	say "If you do the bed will snap in two.";
	stop the action.
After entering the wrecked bed:
	say "You decided to lay on it anyways. The bed, unfortunately, loses stability of itself and snaps in half. You fall on the floor with a loud thunk. Looks like you won't be laying on that bed ever again.";
	wait for any key;
	say line break;
	say "A note falls out of the bed and onto the floor.";
	now the wrecked bed is damaged;
	now the dog is mortified;
	now the description of the wrecked bed is "The bed is in two pieces; you can't lay on it anymore.";
	now Note #4 is in the Anti-Bedroom.
Instead of entering the wrecked bed when the wrecked bed is damaged:
	say "Not anymore."

The description of Note #4 is "[italic type]Just finished a special mirror that will act as a portal. That people at the university are going to freak when they hear about this. They didn't believe in multiverse's or anything of that sort, but will see about that. I can't wait to show them, granted that it works.[roman type]"

[Trespasser's Bedroom - "I don't like politics as much. They misinterpret them."]
The Trespasser's Bedroom is east of the Inverted Second Floor. The description of the Trespasser's Bedroom is "'You are not welcome here anymore.'"

After going east from the Inverted Second Floor:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Check the closet.[line break]- Don't open the drawer.";
	continue the action.

A busted closet, a torn-up bed, a dark bureau, a broken desk, a tattered rug, a grandfather clock, and a shattered chair are in the Trespasser's Bedroom.
The busted closet is a closed openable container. Inside the busted closet is a skeleton. The skeleton is fixed in place.
On the skeleton is Note #7.
The dark bureau is a supporter. The hairy drawer is part of the dark bureau. The hairy drawer is a closed openable container.
The tattered rug is fixed in place.
The grandfather clock is fixed in place.
The mouse is in the grandfather clock. The mouse is an animal. The mouse is female. The mouse is scenery.
Understand "dresser" as dark bureau. Understand "dresser drawer" as hairy drawer.

The description of the busted closet is "Scratch marks are found all over the closet door."
The description of the skeleton is "A spooky, scary skelly. It brings a shiver down your shine."
The description of the torn-up bed is "Another bed with torn sheets and tears in the pillows."
The description of the hairy drawer is "A really fuzzy drawer of the bureau. Eww..."
The description of the dark bureau is "It's deeply black and has sinister eyes painted on it."
The description of broken desk is "Completely busted and unusable."
The description of the shattered chair is "It's been teared to shreds. You can't sit in it in these conditions."
The description of the tattered rug is "The rug has been mangled up. Pieces of it can be found everywhere on the floor."
The description of the grandfather clock is "A large clock that ticks and tocks the minutes away. Unfortunately its broken and is stuck on the 1st hour. That seems fine for the mouse residing in the clock."
The description of the mouse is "A small rodent lives inside the clock. It waves to you on the other side of the glass door. She sits in there in peace and quiet."
The description of Note #7 is "[italic type]Something terrible just happened. The portal is unstable and I can't seem to turn it off.[roman type]"

After opening the busted closet:
	say "'And then a skeleton popped out!'";
	wait for any key;
	say "You aren't afraid of it as much as the clown."
After entering the torn-up bed:
	say "Unlike the bed in the other room this one still supports you despite being in bad conditions."
Instead of putting something on the broken desk:
	say "It can't even support a feather. Poor desk, it won't be able to fulfill its purpose anymore."
Instead of entering the shattered chair:
	say "That's impossible now."
Before opening the hairy drawer:
	say "Open this drawer thing?";
	if player consents, stop the action;
	otherwise end the story saying "Upon opening the disgustingly furry drawer, the entire dresser came alive and stuffed you inside the other drawer. Guess that explains why it was so hairy to begin with."
Instead of taking the mouse:
	say "She seems happy in her little home."
Instead of petting the mouse:
	say "It's inside the clock and the glass door is tightly shut."
Instead of hugging the mouse:
	say "As much as she enjoys the affection you give, she can't return the favor."
Instead of attacking the mouse:
	say "It's not bothering anybody."

Section 8.0 - The Mirrored First Floor

[Unliving Room - "Do they even care anymore?"]
The Inverted Second Floor is up from the Unliving Room. The description of the Unliving Room is "This place is void of life."

After going down from the Inverted Second Floor:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Find a way to open the chest.[line break]- Extinguish the fire.[line break]- Don't enter the door immediately.";
	continue the action.
After going east from the Inverted Dining Room:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Find a way to open the chest.[line break]- Extinguish the fire.[line break]- Don't enter the door immediately.";
	continue the action.
After going south from the Long Hallway:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Find a way to open the chest.[line break]- Extinguish the fire.[line break]- Don't enter the door immediately.";
	continue the action.

A black chair, 2 shredded couches, the mantle piece, a cracked large window, a split table, a dead television, and a busted door are in the Unliving Room.
The dead television is fixed in place.
The mantle piece is a supporter.
A purple chest is on the mantle piece. The purple chest is a locked openable closed container. It is fixed in place.
The firebrand key unlocks the purple chest.
Note #9 is in the purple chest.
The fireplace is part of the mantle piece. The fireplace is a container. The fireplace is fixed in place.
The firewood is part of the fireplace. The firewood is fixed in place.
The busted door is a door. It is south of the Unliving Room. Through it is A Brick Wall.

The description of the black chair is "Don't be racist to the white chair's cousin, ok? Black chair lives matter."
The description of the shredded couch is "Chewed up and ripped apart. Just like the license plate on your car when that bulldog came over and ripped it off. You managed to get it back at least but barely."
The description of the mantle piece is "It's the only thing in the Gothic room that stands out better than anything else."
The description of the fireplace is "Sit down and get toasty."
The description of the firewood is "There's something in the firewood but the fireplace is lit."
The description of the cracked large window is "Through the window you see blackish gray landscapes and an red-ish orange sky. Dead tree are everywhere. The entire outside looks barren of life completely. Maybe it's best to stay indoors today, unless you wish to check out the back."
The description of the split table is "This table was split in two. No use putting things onto it."
The description of the dead television is "Dusty and broken."
The description of the busted door is "Despite it being in bad shape it still holds onto its hinges."
The description of the purple chest is "Very ornate and expensive looking."
The description of Note #9 is "This note is written very poorly, but you can still comprehend what is written on it. Here's what it says:[paragraph break][italic type]'I'm stuck like this. I can't go back to who I was before. Unless someone manages to retrieve that book from the 'other side,' then I may have a chance of returning. For now I wait here in my home until that day comes. As for Flammie, I'm too afraid to see him. I hope he forgives me for what I have done here in my own dimension. Please, someone... anyone who read these notes I made, help us. Take the egg out of the cryogenic fridge and let him hatch. It will make things better for all of us.'[paragraph break]Sincerely, Michael[roman type][paragraph break]...whose Michael?"

Instead of touching the fireplace when the fireplace is smoldering:
	say "Don't touch that it's hot!"
Instead of touching the firewood when the firewood is smoldering:
	say "That's on fire; don't touch it."
Instead of inserting something into the fireplace:
	say "If you were to put something in the fireplace it will burn up. So the answer to that option is 'No.'"
Instead of entering the shredded couch:
	say "Their not suitable for sitting anymore."
Instead of switching on the dead television:
	say "It's broken like the last one back in the regular dimension. Just give up."
After touching the dead television:
	say "Nope, not this time. I'm on to your little tricks, bud."
Instead of putting something on the split table:
	say "That can't be done; the table is split in half."
After opening the purple chest:
	say "...";
	wait for any key;
	say "Am I detecting a pattern here?"

[Busted Front Door - "Being a millennial sucks. Who even invented Generation names in the first place. I hope their proud of themselves."]
After opening the busted door:
	say "The door leads nowhere but a brick wall."; 
	now the description of the busted door is "Good thing you opened it first before just running out without thinking otherwise you would have killed yourself."
Instead of entering the busted door when the busted door is open:
	say "It's bricked up. You can't enter it."
After entering the busted door:
	end the story saying "You ran face first into a brick wall and died on impact. Ouch!"
Instead of closing the busted door:
	say "It can't be shut anymore. It is locked in position."
Instead of going south from the Unliving Room:
	say "Still cannot go south."

[Inverted Dining Room - "Am I really an enemy?"]
The Inverted Dining Room is west of the Unliving Room. The description of the Inverted Dining Room is "'We are not happy to serve to you.'"

After going west from the Unliving Room:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- The plate needs a sweet refill.[line break]- He growls at the piano.";
	continue the action.
After going south from the Inverted Kitchen:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- The plate needs a sweet refill.[line break]- He growls at the piano.";
	continue the action.

A worn-out table, 5 withered chairs, a grand piano, a piano bench, a dusty router, and a dead computer are in the Inverted Dining Room.
The grand piano is a supporter. On the piano is the wilted flowers. The wilted flowers are fixed in place.
The empty plate is on the worn-out table. The empty plate is a supporter. The empty plate is fixed in place.
The dead computer is a switched off device.
The dusty router is scenery.
Understand "pc" and "desktop" as dead computer.

The description of the worn-out table is "The table is covered in stains and a lonely plate is left on the side."
The description of the withered chair is "Each chair is slowly withering away, yet they still seem sturdy to hold you."
The description of the grand piano is "You know how to play piano. Maybe you should give it a play when you get the chance."
The description of the piano bench is "The bench is the only thing in this room that is not in bad conditions. I wonder why."
The description of the dead computer is "An old Macintosh computer. It's connected to the internet router but is barely usable."
The description of the dusty router is "No signal. Figures."
The description of the wilted flowers is "The flowers are all shriveled up."
The description of the empty plate is "Someone or something must have licked this plate clean."

After entering the withered chair:
	say "Yep, Sturdy."
After switching on the dead computer:
	say "The computer was able to turn on, but only shows a blue screen.";
	wait for any key;
	say "A message is also shown:";
	say line break;
	wait for any key;
	say "01000100 01110101 01100100 01100101 00101100 00100000 01001001 00100111 01110110 01100101 00100000 01100111 01101111 01110100 00100000 01100001 00100000 01000100 01100101 01101100 01101100 00101110";
	say line break;
	wait for any key;
	say "I may be a computer but I don't think I can translate it for you at the moment. Unless you feel like doing it.";
	now the dog is unamused.
After switching off the dead computer:
	say "The computer goes back to sleep."
After smelling the wilted flowers:
	say "...death.";
	wait for any key;
	say "...that's all you smell."
Before playing the grand piano:
	say "Do you want to play a cheerful song?";
	if player consents, stop the action;
	otherwise end the story saying "Well, too bad! Instead the piano came alive and ate you up. I guess you can't bring happiness into this world at all."

[Inverted Kitchen - "Am I a roadblock to you?"]
The Inverted Kitchen is north of the Inverted Dining Room. The description of the Inverted Kitchen is "'I wonder what's on the menu today.'"

After going north from the Inverted Dining Room:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Don't turn on the microwave when food is in it.[line break]- Check the drawer.[line break]- He doesn't like that other dog.";
	continue the action.
After going west from the Long Hallway:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Don't turn on the microwave when food is in it.[line break]- Check the drawer.[line break]- He doesn't like that other dog.";
	continue the action.
After going south from the Bloodroom:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Don't turn on the microwave when food is in it.[line break]- Check the drawer.[line break]- He doesn't like that other dog.";
	continue the action.

A twin sink, a shattered cupboard, the fake dog, an non-sturdy stool, and a kitchen counter are in the Inverted Kitchen.
The twin sink is fixed in place.
The shattered cupboard is a transparent openable container. It is fixed in place.
The fake dog is an animal.
The kitchen counter is a supporter.
The microwave is on the kitchen counter. The microwave is a device. It is fixed in place.
The turntable is part of the microwave. The turntable is a supporter.
The kitchen drawer is part of the kitchen counter. The kitchen drawer is a closed openable container.
The rusty silverware is in the kitchen drawer.
The spider is an animal. The spider is part of the twin sink.
Understand "utensils" and "cutlery" as rusty silverware. Understand "nuker" as microwave. Understand "ghost dog" as fake dog.

The description of the twin sink is "Two sinks congealed to one another. You see a lone spider perched on the water spout."
The description of the shattered cupboard is "Broken glass can be found on the floor near the cupboard."
The description of the fake dog is "The dog on your back barks angrily at the apparition of its fake predecessor."
The description of the kitchen counter is "The paint job on the counter is fading away and only one drawer is openable."
The description of the kitchen drawer is "The only door that is not glued shut."
The description of the rusty silverware is "Slightly bent and very rusty, but still shiny a bit on certain parts."
The description of the microwave is "A nuking device for food, not for small rodents."
The description of the turntable is "A plate that spins with the microwave."
The description of the non-sturdy stool is "The red chair stool is not as sturdy as it used to be."
The description of the spider is "Kill it with fire!"

Instead of taking the fake dog:
	say "I'm pretty sure 'he' would not appreciate it if you did.";
	now the dog is agitated.
Instead of petting the fake dog:
	say "The fake dog snarls at you. You should probably keep your distance from it.";
	now the dog is agitated.
Before going north from the Inverted Kitchen:
	if the fake dog is not in the Inverted Kitchen, continue the action;
	otherwise say "The ghostly dog blocks the entrance to the other room."; stop the action.
Instead of opening or closing the shattered cupboard:
	say "Do you want to get a glass cut? I don't think so."
After switching on the microwave:
	if the cake is on the turntable, end the story saying "You just destroyed an important item. Nice going.";
	otherwise say "The light in the microwave turns on and the plate inside begins to rotate."
After switching on the twin sink:
	say "Nothing but dust puffs out of the faucet."
Instead of entering the non-sturdy stool:
	say "It's not even sturdy enough to grasp onto itself, what makes you think it can hold you?"
Before taking the rusty silverware:
	say "Take the silverware?";
	if player consents, stop the action;
	otherwise continue the action.
After using the rusty silverware on the fake dog:
	say "The fake canine gets spooked by the silverware you wield and disappears. It drops a note on the floor.";
	now the fake dog is nowhere;
	now Note #6 is in the Inverted Kitchen.
Before attacking the fake dog:
	say "I'm pretty sure the last time I checked you can't attack a ghost physical, but do you wanna try anyways?";
	if player consents, stop the action;
	otherwise end the story saying "Your attack phased through the dog and all of a sudden the ghost dog retaliated. Now your possessed by the dog and have lost all conscious of your own freewill. You now wander this house endlessly with no real goal to achieve. That's no bueno."
Instead of petting the spider:
	say "Are you freaking nuts?"
Instead of hugging the spider:
	say "I hope you like getting bitten?"
Instead of taking the spider:
	say "Remember that one guy who got bitten by a radioactive spider and became a hero?";
	wait for any key;
	say "Yeah, that won't happen to you."
After attacking the spider:
	end the story saying "The spider was quick and nimble and dodged your attack. Before you had a chance for a counterattack, the spider grabbed hold of your weapon and flung you out of the house and locked all the windows and doors. Now your trapped outside and can't get in. The spider refuses to let you back in after that. Looks like this is game over for you because you can't keep moving forward. Maybe next time we should just leave it alone."

The description of Note #6 is "[italic type]I have decided to test it this machine on myself now, because everyone else is too concerned that this may be dangerous for their own well being. I mean, I've tested it on inanimate objects and it works just fine. All I need to do is test it on something living to confirm it's safe and well tested and they refuse to try it out. I already promised them they will be fine. Why can't they just take a chance?[roman type]"

[Long Hallway - "I used to be funny."]
The Long Hallway is east of the Inverted Kitchen and north of the Unliving Room. The description of the Long Hallway is "This new hallway stretches longer than the other hallway. On the floor, you see a red liquid. Is this..."

After going north from the Unliving Room:
	now the dog is content;
	now the description of the dog is "He's got nothing about this room. It's just a convenient way of getting from room to room, that's all.";
	continue the action.
After going south from the Inverted Lower Bathroom:
	now the dog is content;
	now the description of the dog is "He's got nothing about this room. It's just a convenient way of getting from room to room, that's all.";
	continue the action.
After going east from the Inverted Kitchen:
	now the dog is content;
	now the description of the dog is "He's got nothing about this room. It's just a convenient way of getting from room to room, that's all.";
	continue the action.
After going west from the Inverted Bedroom:
	now the dog is content;
	now the description of the dog is "He's got nothing about this room. It's just a convenient way of getting from room to room, that's all.";
	continue the action.
After going up from the Floating Basement:
	now the dog is content;
	now the description of the dog is "He's got nothing about this room. It's just a convenient way of getting from room to room, that's all.";
	continue the action.

The small decaying drawer, some inverted photos, and some blood trails are in the Long Hallway.
The inverted photos are fixed in place.
The decaying drawer is a supporter.
The withered school model is on the decaying drawer. It is fixed in place.
The blood trails are scenery.
Understand "red liquid" as blood trails. Understand "pictures" as inverted photos.

The description of the inverted photos is "Various pictures of you and your loved ones hang on the wall. One of them being that vest boy again. How the heck did they get here? Has someone been watching you? This gives you an uneasy vibe."
The description of the withered school model is "A model of your old elementary school. It closed down a long time ago due to a lack of funds and participation. It was tragic for you and your sister to see this happen; so many joyful-ish memories now washed away. It's still around but only as a church. Seeing this thing withering away brings a tear down your eye."
The description of the decaying drawer is "The wood is being chipped away. At the rate of its decomposition it will cease to stand up and support the model on top of it."
The description of the blood trails is "...Blood? ...The trail leads down the hallway to each room including the basement."

Instead of taking the withered school model:
	say "Sadly you can't take it back home. It's stuck in place and refuses to budge. Farewell, sweet prince.";
	now the dog is sad.

[Bloodroom - "What is wrong with me?!"]
The Bloodroom is north of the Inverted Kitchen. The description of the Bloodroom is "A red tainted room. Do I need to go into more details for you?"

After going north from the Inverted Kitchen when the white wyvern is menacing:
	now the dog is petrified;
	now the description of the dog is "He's too focused on the giant lizard to say anything about this room.";
	continue the action.
After going north from the Inverted Kitchen when the white wyvern is content:
	now the dog is content;
	now the description of the dog is "He's too focused on the giant lizard to say anything about this room.";
	continue the action.
After going inside from the Cemetery:
	now the dog is content;
	now the description of the dog is "He's too focused on the giant lizard to say anything about this room.";
	continue the action.

The bloody table, the bloody chair, a dusty platform, 9 stained windows, and white wyvern are in the Bloodroom.
The dusty platform is an enterable supporter.
The white wyvern is an animal. The white wyvern is male.
Understand "serpent", "lizard", "reptile", "dragon", and "Flammie" as white wyvern.

The description of the bloody table is "A red table."
The description of the bloody chair is "A red chair."
The description of the dusty platform is "A plaque can found on the side of the platform. It says 'Please refrain from antagonizing Flammie. He's won't bother you as long as you don't egg him on.'"
The description of the stained window is "Through the window you can barely see the outside. All the windows are covered with smudges."
The description of the white wyvern is "YIKES!!!! HOW LONG HAS THAT THING BEEN THERE FOR?!"

Instead of taking the white wyvern:
	say "He's too big and heavy to carry."
Instead of petting the white wyvern when the white wyvern is menacing:
	say "That's a terrible idea you know."
After examining the white wyvern for the first time:
	wait for any key;
	say "...sorry, got a little jumpy there. Anyways, the large white reptile stands in the corner, guarding the doorway outside. Instead of attacking you immediately it gazes at you with a stare that makes you feel immobilized.";
	now the description of the white wyvern is "It's like he's piercing into your soul.";
	now the description of the Bloodroom is "There's no way past him unless you can find a way to make him move out of the way of the door."
After examining the dusty platform for the first time:
	say "Is it talking about the dragon?";
	now the printed name of the white wyvern is "Flammie".
Instead of going outside from the Bloodroom when the white wyvern is menacing:
	say "He won't let you pass."
Instead of going outside from the Bloodroom when the white wyvern is bewildered:
	say "???"
After entering the bloody chair:
	say "Huh... neat."
After entering the dusty platform:
	say "You get on the platform. There's eggshell pieces all over it."
Before attacking the white wyvern when the white wyvern is menacing:
	say "Yeah right. You have no chance against a creature like that. Do you really want to try?";
	if player consents, stop the action;
	otherwise end the story saying "Before you even had a chance to get your weapon out, the giant wyvern slaps you silly across the entire room. It's as if it knew what your next move would be. You hit the wall hard and fall down incapacitated. Told ya you had no chance."
After attacking the white wyvern when the white wyvern is bewildered:
	end the story saying "Annnnnnnd... you've been torched.[line break]I knew that was going to happen. Then again, you did deserve that."
Instead of attacking the white wyvern when the white wyvern is content:
	say "Ummm... uh, yeah no."
Instead of attacking the white wyvern when the white wyvern is curious:
	say "The answer is still no."
Instead of attacking the white wyvern when the white wyvern is curious more than five times:
	say "I don't care if [bold type]Yes[roman type] equals [bold type]No[roman type] and [bold type]No[roman type] equals [bold type]Yes[roman type] in this realm.";
	wait for any key;
	say paragraph break;
	say "[bold type]No... is still No![roman type]";
	say line break.

Section 8.1 - Confronting the Beast

[The wyvern - "Do you truly believe in hope? I try to."]
After walking up to the white wyvern for the first time:
	say "What are you doing?! Have you gone nuts.";
	now the dog is worried.
After walking up to the white wyvern for the second time:
	say "No seriously, what?!"
After walking up to the white wyvern for the third time:
	say "I'm starting to question your 'good decisions' right now."
After walking up to the white wyvern for the fourth time:
	say "Please stop. I don't want this to happen you."
After walking up to the white wyvern for the fifth time:
	say "Agh... I can't watch this any longer than I need to.";
	now the dog is scared.
After walking up to the white wyvern for the sixth time:
	say "(Your now at arms reach of Flammie. What are you going to do now?)[line break]He looks at you with bewilderment.";
	now the white wyvern is bewildered.
After petting the white wyvern when the white wyvern is bewildered:
	say "You reach your hand out to Flammie. He examines your hand carefully and approaches it slowly.";
	wait for any key;
	say "As soon as you touched him, he sits there contently, looks at the platform for a second and remembers who you are.";
	wait for any key;
	say line break;
	say "Flammie moves away from the door. He will let you pass now. Also a note appeared on the table. (Wow I can't believe that actually worked. This has been such a weird day.)";
	now the white wyvern is content;
	now the description of the white wyvern is "Flammie is [state].";
	now the description of the Bloodroom is "Flammie sits in this room quietly and obedient. He seems to enjoy your company every once in a while.";
	now the description of the giant egg is "...Flammie.";
	now the printed name of the white wyvern is "Flammie";
	now Note #3 is on the bloody table;
	now the dog is bewildered.
After petting the white wyvern when the white wyvern is content:
	say "(Man, wait until the boys back at home hear about this.)";
After petting the white wyvern when the white wyvern is curious:
	say "If only he was smaller then you could take him with you. The dog seems rather used to his presence now.";
	now the dog is content.

The description of Note #3 is "[italic type]This egg I found is rather unusual. I feel like I should conserve it somewhere just incase. I don't have time to watch over it as of now plus it doesn't seem ready to be hatched yet. I wonder what it will be when it does? A dragon maybe?[line break]...Nah that seems too good to be true.[roman type]"

[Cemetery - "I just want to be a part of the crowd."]
The Cemetery is outside of the Bloodroom. The description of the Cemetery is "The dry wind howls in an eerie tone."

After going outside from the Bloodroom:
	now the dog is content;
	now the description of the dog is "All he asks is that you don't lose your knife when pushing the loose tombstone.";
	continue the action.

The tombstone, some dead grass, some dead trees, a metal fence, some gray clouds, and the sky are in the Cemetery.
The dead grass, dead trees, gray clouds, and sky are scenery.
The fence door is part of the metal fence. The fence door is a closed openable container.
A rock is a thing.
Understand "headstone" as tombstone.

The description of the tombstone is "'You're next!' says one of the many tombstones. The one to your left looks loose and can easily be moved."
The description of the dead grass is "Dark gray and void of life."
The description of the dead trees are "They stand up tall with a ghastly shadow looming on you."
The description of the gray clouds are "Not a single silver lining can be found on each cloud."
The description of the sky is "It's deep, dark, and orange."
The description of the metal fence is "The entire borderline of the house is surrounded by the fence."
The description of the fence door is "Opening the fence would let you leave, but you can't because its locked up."
The description of the rock is "Small, hard, and gray. Good throwable material.[line break](P.S. - Don't throw it at any windows.)"

Instead of opening the fence door:
	say "'There is no escape.'"
Instead of taking the tombstone:
	say "That's too heavy to take."

Section 8.2 - Battle Time

[The Zombie Battle - "He thinks I'm weak, I just know it."]
Before pushing the tombstone:
	say "Push the stone?";
	if player consents, stop the action;
	otherwise continue the action.

After pushing the tombstone for the first time:
	say "You pushed the heavy tombstone out of the way. Suddenly, a zombie pops out of the ground. Whoa![line break]You immediately back away and head towards the door back inside but as you approached the door, a bunch of prickly vines grew around it blocking your escape. Looks like you have no choice but to defeat the zombie.";
	now Zombie 1 is in the Cemetery;
	now some vines are in the Cemetery;
	now the description of the Cemetery is "I hope you didn't throw that knife away.";
	now the description of the tombstone is "'See? Too ya you were next?'";
	now the dog is disgusted.
	The description of Zombie 1 is "Undead and out for flesh."
	The description of the vines are "Sharp and pointy. No way of cutting them down."
	The vines are scenery.

Instead of going inside from the Cemetery when the vines are in the Cemetery:
	say "Trapped."

After attacking Zombie 1:
	say "You attacked the zombie and it fainted.

	Two more appear.[line break](Examine each zombie to know which one to attack next. Choosing the wrong one may end your life.)";
	now Zombie 1 is nowhere;
	now Zombie 2 is in the Cemetery;
	now Zombie 3 is in the Cemetery;
	now the description of the Cemetery is "Choose wisely."
	The description of Zombie 2 is "The left zombie is about to attack."
	The description of Zombie 3 is "The right zombie is waiting."

After attacking Zombie 2 when Zombie 2 is attack for the first time:
	say "The zombie fainted.

	Another zombie appeared.";
	now Zombie 2 is wait;
	now the description of Zombie 2 is "The left zombie is waiting.";
	now Zombie 2 is nowhere;
	now Zombie 3 is attack;
	now the description of Zombie 3 is "The right zombie is about to attack.";
	now Zombie 4 is in the Cemetery;
	now the description of the Cemetery is "What! Another one?"
	The description of Zombie 4 is "The middle zombie is waiting."

After attacking Zombie 3 when Zombie 3 is attack for the first time:
	say "The zombie fainted.

	Another one appeared.";
	now Zombie 3 is wait;
	now the description of Zombie 3 is "The right zombie is waiting.";
	now Zombie 3 is nowhere;
	now Zombie 4 is attack;
	now the description of Zombie 4 is "The middle zombie is about to attack.";
	now Zombie 2 is in the Cemetery;
	now the description of the Cemetery is "Oh no."

After attacking Zombie 4 when Zombie 4 is attack for the first time:
	say "The zombie fainted.

	Another one appeared.";
	now Zombie 4 is wait;
	now the description of Zombie 4 is "The middle zombie is waiting.";
	now Zombie 4 is nowhere;
	now Zombie 2 is attack;
	now the description of Zombie 2 is "The left zombie is about to attack.";
	now Zombie 3 is in the Cemetery;
	now the description of the Cemetery is "This is gonna go on for a while huh?"

After attacking Zombie 2 when Zombie 2 is attack for the second time:
	say "The zombie fainted.

	Another one appeared.";
	now Zombie 2 is wait;
	now the description of Zombie 2 is "The left zombie is waiting.";
	now Zombie 2 is nowhere;
	now Zombie 4 is attack;
	now the description of Zombie 4 is "The middle zombie is about to attack.";
	now Zombie 4 is in the Cemetery;
	now the description of the Cemetery is "Yep."

After attacking Zombie 4 when Zombie 4 is attack for the second time:
	say "The zombie fainted.

	Another one appeared. (Jeez... their relentless.)";
	now Zombie 4 is wait;
	now the description of Zombie 4 is "The middle zombie is waiting.";
	now Zombie 4 is nowhere;
	now Zombie 3 is attack;
	now the description of Zombie 3 is "The right zombie is about to attack.";
	now Zombie 2 is in the Cemetery;
	now the description of the Cemetery is "Keep at it."

After attacking Zombie 3 when Zombie 3 is attack for the second time:
	say "The zombie fainted.

	And another one.";
	now Zombie 3 is wait;
	now the description of Zombie 3 is "The right zombie is waiting.";
	now Zombie 3 is nowhere;
	now Zombie 4 is attack;
	now the description of Zombie 4 is "The middle zombie is about to attack.";
	now Zombie 4 is in the Cemetery;
	now the description of the Cemetery is "Don't lose focus."

After attacking Zombie 4 when Zombie 4 is attack for the third time:
	say "The zombie fainted.

	Another zombie. (I knew playing Resident Evil was a bad idea.)";
	now Zombie 4 is wait;
	now the description of Zombie 4 is "The middle zombie is waiting.";
	now Zombie 4 is nowhere;
	now Zombie 3 is attack;
	now the description of Zombie 3 is "The right zombie is about to attack.";
	now Zombie 3 is in the Cemetery;
	now the description of the Cemetery is "Your almost there."

After attacking Zombie 3 when Zombie 3 is attack for the third time:
	say "The zombie fainted.

	One left... literally left.";
	now Zombie 3 is wait;
	now the description of Zombie 3 is "The right zombie is waiting.";
	now Zombie 3 is nowhere;
	now Zombie 2 is attack;
	now the description of Zombie 2 is "The left zombie is about to attack.";
	now the description of the Cemetery is "Hit 'em hard."

After attacking Zombie 2 when Zombie 2 is attack for the third time:
	say "The zombie fainted.

	I guess that's all of the...";
	wait for any key;
	say "oh wait, nevermind.";
	wait for any key;
	say "Another zombie just appear and this one looks bigger than the others.";
	now Zombie 2 is wait;
	now the description of Zombie 2 is "The left zombie is waiting.";
	now Zombie 2 is nowhere;
	now Zombie 5 is in the Cemetery;
	now the description of the Cemetery is "Show no mercy."
	The description of Zombie 5 is "The zombie is going for an attack."

After dodging Zombie 5 when Zombie 5 is attack:
	say "You dodged the upcoming attack. It's vulnerable for attack.";
	now Zombie 5 is vulnerable;
	now the description of Zombie 5 is "The zombie is vulnerable.";
	now the description of the Cemetery is "Good call."

After attacking Zombie 5 when Zombie 5 is vulnerable for the first time:
	say "The zombie got damaged. It readies itself.";
	now Zombie 5 is dodge;
	now description of Zombie 5 is "The zombie is preparing for an attack.";
	now the description of the Cemetery is "Not too shabby."

After attacking Zombie 5 when Zombie 5 is dodge:
	say "The attack missed.";
	now Zombie 5 is attack;
	now the description of Zombie 5 is "The zombie is going for an attack.";
	now the description of the Cemetery is "Keep going."

After skipping turn on Zombie 5 when Zombie 5 is dodge:
	say "You waited for a clear opening.";
	now Zombie 5 is attack;
	now the description of Zombie 5 is "The zombie is going for an attack.";
	now the description of the Cemetery is "Smart move."

After attacking Zombie 5 when Zombie 5 is vulnerable for the second time:
	say "The zombie gets damaged and dissipates into nothing.

	The zombies stop spawning. Thank goodness. As the large zombie disappears it leaves behind a note and a rock.";
	now Zombie 5 is wait;
	now the description of Zombie 5 is "Dead.";
	now Zombie 5 is nowhere;
	now the vines are nowhere;
	now Note #8 is in the Cemetery;
	now a rock is in the Cemetery;
	now the description of the Cemetery is "The winds are still howling in an eerie tone.";
	now the description of the Backyard is "The birds chirp again.";
	now the description of the tombstone is "'I knew I should have called a vampire instead.'";
	now the dog is glad.

The description of Note #8 is "[italic type]Now the machine won't cooperate. I don't understand. Why are these contraptions going all haywire? They were just working fine before.[roman type]"

[Wrong Decision - "I sometimes have an existential crisis."]
After attacking a wait zombie:
	end the story saying "Wrong."

After attacking Zombie 5 when Zombie 5 is attack:
	end the story saying "Dead."

[Inverted Lower Bathroom - "Being a child kind of sucked, but it also was easier."]
The Inverted Lower Bathroom is north of the Long Hallway. The description of the Inverted Lower Bathroom is "Another unwashed bathroom. Good thing you already took a shower before you left."

After going north from the Long Hallway:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Check back with the cabinet when you have 8 notes.[line break]- Don't go into the bathtub.";
	continue the action.

A shattered medicine cabinet,a bent toilet, a broken bathtub, and a warped sink are in the Inverted Lower Bathroom.
The warped sink is fixed in place.
The shattered medicine cabinet is a container. It is fixed in place.
Inside the shattered medicine cabinet is Note #5.
The broken bathtub is an enterable supporter.
Understand "tub" as broken bathtub.

The description of the shattered medicine cabinet is "The mirror and door have fallen off the cabinet. It hangs on the wall empty and barren."
The description of the broken bathtub is "Cracks can be found everywhere on the exterior of the tub. The curtains that company the tub are all wrinkled up."
The description of the bent toilet is "The toilet is all disfigured and out of proportion with itself."
The description of the warped sink is "It's handles and bowl bend in irregular shapes."
The description of Note #5 is "[italic type]Well now that I'm done with that invention I'll just continue on my other project. This project is expected change the appearance or any living creature into something else, including people. I can just imagine what wonders people will think of this. Running as fast as a cheetah, soaring the sky like an eagle, or visiting the vast depths of the ocean as a whale. I swear, this will change the world indefinitely. Now who to test it on is the question?[roman type]"

After entering the bent toilet:
	say "Still don't need to go."
After switching on the warped sink:
	say "Red mist flows out of the sink and up into the air."
Before entering the broken bathtub:
	say "Lay in the tub?";
	if player consents, stop the action;
	otherwise end the story saying "As you enter the tub, the shower curtains close up and a thick glass wall blocks your way out entirely. Water spurts out of the shower head at a furious pace, causing the tub to fill up really quickly. The water level eventually reaches to the top of the ceiling and you desperately try to break you way out, but to no prevail do you succeed in escaping. The dog on the other side of the glass whimpers to you and tries to help you out but fails as well. Eventually, you gasp you last breath and go out quietly. What a terrible way to go."

[Inverted Bedroom - "Writing is the only way I can my thoughts out fully."]
The Inverted Bedroom is east of the Long Hallway. The description of the Inverted Bedroom is "'Rest a while. Rest forever!'"

After going east from the Long Hallway:
	now the dog is content;
	now the description of the dog is "Here is what he has to say:[paragraph break]- Get the coat.[line break]- Don't go inside the armoire or turn on the TV.";
	continue the action.

A king-size bed, a chipped wardrobe, a busted clock, and a small broken television are in the Inverted Bedroom.
The small broken television is fixed in place.
The chipped wardrobe is an enterable container. It is fixed in place.
The thermal coat is in the chipped wardrobe. The thermal coat is wearable.
The busted clock is fixed in place.
The inverted closet is an enterable closed openable container. It is fixed in place.
Understand "armoire" as chipped wardrobe. Understand "winter coat" as thermal coat.

The description of the king-size bed is "A bed fit for a king. It's the only bed that has been left undamaged but has grown dusty and uncomfortable to lay on."
The description of the chipped wardrobe is "The doors on the wardrobe are missing and the outside of the closet is in bad shape."
The description of the busted clock is "The second and minute hand is stuck ticking in the same position while the hour hand got bent."
The description of the inverted closet is "Another ruined closet."
The description of the small broken television is "Smoke is emitting out of the back of the television. The TV is trying to turn itself on but shuts off immediately when trying, leaving behind a mess of static each time."
The description of the thermal coat is "Big, blue, and fluffy on the inside. Looks tough and cozy."

After entering the king-size bed:
	say "[italic type]*cough cough*[roman type] ...it's... [italic type]*cough*[roman type] ...so hard... [italic type]*aaach*[roman type] ...to breath... [italic type]*cough hack*[roman type]".
Before entering the chipped wardrobe:
	say "Enter the wardrobe?";
	if player consents, stop the action;
	otherwise end the story saying "As you approach the wardrobe a lion pops out from behind the coats hung up inside the wardrobe and drags you in. You never came back out of the armoire again."
Before switching on the small broken television:
	say "Wanna try and turn it on yourself?";
	if player consents, stop the action;
	otherwise end the story saying "The TV flashes a million images simultaneously and then combusted in your face. The explosion left you impaled and on the ground. I don't think you survived that, but at least the dog did."
After entering the inverted closet for the first time:
	say "No... No... No... We are not playing this game again. In fact, I'm not going to even ask you anymore, I'm just going to wait until you decided to cooperate with me and play this game the way it was intended to be played. So there.";
	now the closet is locked;
	now the closet is closed;
	now the description of the closet is "[bold type]Sucker![roman type]".
Instead of opening the closet when the closet is locked:
	say "Nope.avi";
	say line break.
After entering the inverted closet:
	say "..."
Before taking the thermal coat:
	say "Take the thermal coat?";
	if player consents, stop the action;
	otherwise continue the action.
After wearing the thermal coat:
	say "A horrible chill runs down your spine as you put on the coat."

[Prevent wearing two layers at once - "I'm still here."]
Instead of wearing the thermal coat:
	if the player is wearing the brown jacket, say "You'll need to take off your jacket first.";
	otherwise continue the action.

Instead of wearing the brown jacket:
	if the player is wearing the thermal coat, say "You'll need to take off your coat first.";
	otherwise continue the action.

Section 8.3 - The Underground

[Prevent going downstairs again without another equipped item - "Disappointment is common."]
Instead of going down from the Long Hallway:
	if the player is wearing the thermal coat, continue the action;
	otherwise say "A cold breeze prevents you from entering the basement."

Instead of going north from the Burning Cellar:
	if the player is wearing the thermal coat, continue the action;
	otherwise say "It's too cold in there. You'll freeze up without proper protection from the extreme weather."

Instead of going west from the Back Dungeon:
	if the player is wearing the thermal coat, continue the action;
	otherwise say "It's too cold in there. You'll freeze up without proper protection from the extreme weather."

Section 9.0 - Hell's Basement

[Floating Basement - "Ignorance is still bliss."]
The Floating Basement is down from the Long Hallway. The description of the Floating Basement is "...I have no words for this place other than how chilly it is in here."

After going down from the Long Hallway:
	now the dog is scared;
	now the description of the dog is "He wants you to get the mask from the basket.";
	continue the action.
After going north from the Burning Cellar:
	now the dog is scared;
	now the description of the dog is "He wants you to get the mask from the basket.";
	continue the action.
After going west from the Back Dungeon:
	now the dog is scared;
	now the description of the dog is "He wants you to get the mask from the basket.";
	continue the action.

A freezer box, a corrupted washer, a corrupted dryer, a torn-up wicker basket, ice, some icicles, a sealed circuit breaker, and some dangling chains are in the Floating Basement.
The dangling chains, ice, and icicles are scenery.
The freezer box is an open container. The freezer box is fixed in place. The freezer box can be cold. The freezer box is cold.
The corrupted washer and corrupted dryer are a switched on device.
The corrupted washer and corrupted dryer are fixed in place.
The evil clown is a man.
The torn-up wicker basket is a container. It is fixed in place.
Inside the torn-up wicker basket is a gas mask.
The gas mask is wearable.
The sealed circuit breaker is a device. The wires are part of the sealed circuit breaker.

The description of the freezer box is "Unlike a refrigerator, a freezer box will keep food cold and frozen. The freezer door is wide open and is causing the ceiling to solidify with icicles and the floor to become slippery. Watch your step."
The description of the corrupted washer is "This washer has been tampered with and is causing a flurry of snow to pump out constantly."
The description of the corrupted dryer is "The dryer is malfunctioning and is making vapor puff out uncontrollably."
The description of the evil clown is "That clown is out for blood. If I were you I would stay as far away from it as possible."
The description of the torn-up wicker basket is "The basket has been stretched into pieces. It is perched on one of the many dangling chains in the room."
The description of the dangling chains are "Various chains dangle everywhere. Some on the ceiling and many on the floor hovering in midair."
The description of the ice is "This room is nothing but ice."
The description of the icicles are "They hang there on the wall, waiting for someone to walk by so they can fall off the ceiling and impale their next victim."
The description of the gas mask is "A mask used for breathing in noxious places."
The description of the sealed circuit breaker is "The circuit breaker has been sealed shut with no way of operating it. Nothing but wires protrude from each side of the box."
The description of the wires are "Various wires tangle and twist in many directions. They can be found on the walls, in the walls, up and down each room of the house, and even outside. They are incredibly thick and cannot be cut. But why would you want to do that? That can be very dangerous."

Instead of switching on or switching off the sealed circuit breaker:
	say "That's a bit far-fetched, don't you think?"
Instead of switching off the corrupted washer:
	say "The washer refuses to be shut off."
Instead of switching off the corrupted dryer:
	say "The dryer's off switch is stuck. No way of calming this thing down."
Instead of taking the evil clown:
	say "Don't."
Instead of walking up to the evil clown:
	say "I'd rather you not."
After attacking the evil clown:
	end the story saying "You were no match for the clown. Perhaps there's another way of dealing with him."
Instead of taking off the thermal coat in the Floating Basement:
	say "Do you want to be turned into a Popsicle?"
Instead of closing the freezer box:
	say "The door is frozen in place."
Instead of taking the gas mask:
	if the evil clown is in the Floating Basement, say "You can't get to the mask with that dastardly clown blocking the way.";
	otherwise continue the action.
Before taking the gas mask:
	say "Get the mask?";
	if player consents, stop the action;
	otherwise continue the action.
After wearing the gas mask:
	say "Great! Now you can enter the room to the south."

[Rock throw - "At least I was trying to be good in school, and I did for the most part."]
Before throwing the rock at the icicles:
	if the evil clown is in the Floating Basement, continue the action;
	otherwise say "There's no need to do that."; stop the action.

After throwing the rock at the icicles:
	say "One of the large icicles falls off the ceiling and jabs the clown, who bursts into a pile of confetti afterwards. I guess that's one way of dealing with a psychotic clown.";
	now the evil clown is nowhere;
	now the rock is nowhere;
	now some confetti is in the Floating Basement.
	The confetti is fixed in place.
	The description of the confetti is "Colorful."

[Prevent going into the Fire Cellar without mask - "Even if I was to leave, I'd still be here."]
Instead of going south from the Floating Basement:
	if the player is wearing the gas mask, continue the action;
	otherwise say "A strong feeling inside you is telling you not to go in that room without a protective mask."

[Burning Cellar - "Depression is normal, right?"]
The Burning Cellar is south of the Floating Basement. The description of the Burning Cellar is "WHOA!!! This place is on fire! Literally!"

After going south from the Floating Basement:
	now the dog is worried;
	now the description of the dog is "Search through the papers and quickly.";
	continue the action.

Some burnt paper and fire are in the Burning Cellar.
The fire is scenery.
The burnt paper is fixed in place.

The description of the fire is "Fire's roar through the cracks in the walls, leaving behind ashes and smoke everywhere."
The description of the burnt paper is "All the paper goods are tarnished and covered in black soot."
The description of the white orb is "A small orb of illusion."

Instead of taking off the gas mask in the Burning Cellar:
	say "Don't do it. You'll suffocate if you do."
After searching through the burnt paper for the first time:
	say "You scavenged through the rubble of charred paper and found a white orb.";
	now the white orb is in the Burning Cellar.

[White orb - "It's not a waste. None of it was."]
After taking the white orb for the first time:
	say "You hear something upstairs.";
	now the microwave is switched off;
	now the cake is on the turntable;
	now the bucket is on the bloody table.
	The cake is edible.
	The bucket is an empty container.
	The description of the cake is "It's a lie, don't eat it!"
	The description of the bucket is "An empty, dry bucket."

[The cake act - "I'm not a quitter, especially with college."]
Before taking the cake:
	say "Take the lie?";
	if player consents, stop the action;
	otherwise continue the action.

Instead of eating the cake:
	say "After taking one lick from the cake you shoved it away from your mouth immediately. It tastes terrible."

After putting the cake on the empty plate:
	say "You place the cake on the plate. This cake was meant to be placed here; it just feels right.

	Upon further inspection, a note appeared next to the cake.";
	now Note #2 is on the worn-out table;
	now the cake is fixed in place;
	now the description of the cake is "Still a lie, don't eat it.";
	now the description of the empty plate is "Whole again.";
	now the description of the Dining Room is "A ghostly figure appears on the table.";
	now the printed name of the empty plate is "plate".

The description of Note #2 is "[italic type]Good news, just paid off the electric bill. Bad news, the news has reported that people have been losing power unexpectedly and I just so happen to be one of them. At least I was about to leave my inventions unplugged and in conservative mode before this happen. This stuff is delicate and a working progress so the last thing I want happening is something bad happening to me, my loved ones or anything else I cherish.[roman type]"

[The bucket act - "I will never lose hope. The candle's ember still burns."]
Before taking the bucket:
	say "Grab the bucket?";
	if player consents, stop the action;
	otherwise continue the action.

After taking the bucket:
	say "Feels sturdy. This may come in some good use.";
	now the white wyvern is curious;
	now the description of the white wyvern is "Flammie is [state] as to what you will be doing next."

After filling the bucket with water:
	say "You filled the bucket with water.";
	now the bucket is waterfilled;
	now the description of the bucket is "A wet, waterfilled bucket."

Instead of filling the backpack with water:
	say "That's not a good filler for liquids. Also the dog is residing in the backpack, so he may not appreciate being wet either."

After pouring the bucket on the firewood when the bucket is waterfilled:
	say "You poured the water on the fire and it goes out.";
	now the bucket is empty;
	now the description of the bucket is "Empty again.";
	now the fireplace is cool;
	now the firewood is soggy;
	now the description of the fireplace is "Not so toasty anymore.";
	now the description of the firewood is "The wood is all moist.";
	now the description of the Living Room is "It smells like smoke in here.";
	now the firebrand key is in the fireplace.
	The description of the firebrand key is "'That's a spicy meatball.' It unlocks the chest on the mantle piece."

[Back Dungeon - "Please don't take any of this the wrong way."]
The Back Dungeon is east of the Floating Basement. The description of the Back Dungeon is "It's damp in here."

After going east from the Floating Basement:
	now the dog is content;
	now the description of the dog is "He's silent. Looks like you'll have to figure it out from here.";
	continue the action.

A wooden signpost, 6 rickety cages, some skulls, some bone piles, water, some puddles, some stalactites, some stalagmites, and a shrine are in the Back Dungeon.
The wooden signpost is fixed in place.
The rickety cage is fixed in place.
The skulls, bone piles, puddles, water, stalactites, and stalagmites are scenery.
The shrine is fixed in place.
The altar is part of the shrine. The altar is a supporter.
The plaque is part of the shrine.
The doppleganger is a man.
The doppleganger is carrying the cursed sword.
Understand "dark twin", "faker", "impersonator", "copycat", and "demon" as doppleganger.

The description of the wooden signpost is "'Welcome to your new home soon.'"
The description of the rickety cage is "This dank, dark cave consists of a few metal cages that sway back and forth from the ceiling. Most of them are being occupied by nothing but skulls and bones."
The description of the puddles are "Water puddles can be found everywhere on the floor. The stalactites are dripping off water from the leaky lime-diseased ceiling, which is causing these puddles and stalagmites to form."
The description of the stalagmites is "Various floor pillars made by the saltwater leaking from the ceiling. Their cousins, the stalactites, like to hang around on the ceiling."
The description of the stalactites is "Various ceiling spears made by the saltwater leaking from the ceiling. Their cousins, the stalagmites, like to chill on the cave floor."
The description of the skulls are "Unidentified skulls are found everywhere in the room including the walls."
The description of the bone piles are "Several huge piles of pale bones are located in certain parts of the room. They are also accompanied by pale skull heads as well."
The description of the water is "Water seams through the cracks and creates small waterfalls on the top edges of the walls."
The description of the shrine is "A small shrine stands at the far end of the room with a small staircase leading up to the altar. It is decorated with ivy all over and has a few torches perched in a neat row to signify it as something important."
The description of the altar is "There is nothing on the altar. A plaque can be found in front of it."
The description of the plaque is "'[italic type]hturt eht wonk ot seton enin eht dinf[roman type]'[paragraph break] This text is kinda hard to make out."
The description of the cursed sword is "A sword that illuminates a deadly glow."
The description of the doppleganger is "It's your look-alike. He's just standing there... menacingly."

Instead of entering the rickety cage:
	say "These cages are for locking up bad people with bad intentions and you my friend are no bad person...";
	wait for any key;
	say "[italic type]hopefully[roman type]."
Instead of taking the doppleganger:
	say "Bad idea."

Section 10.0 - The True Final Room

[The 9 Notes - "Sometimes you just need to vent out your frustration."]
Check taking inventory:
	if the player is carrying nine mysterious papers:
		say "[italic type]You got all the mysterious notes![roman type]".

Instead of taking Note #5:
	if the player is carrying eight mysterious papers, continue the action;
	otherwise say "This note won't budge."

Instead of examining Note #5:
	if the player is carrying eight mysterious papers, continue the action;
	otherwise say "The back side of the note is only shown. A large number 8 is drawn on it."


After taking Note #5:
	say "That was the last note in the entire house.";
	wait for any key;
	say "Great job!";
	wait for any key;
	now the printed name of the Inverted Lower Bathroom is "Inverted Bathroom (Dark)";
	now the printed name of the Long Hallway is "Hallway (Dark)";
	now the printed name of the Inverted Bedroom is "Bedroom (Dark)";
	now the printed name of the Inverted Kitchen is "Kitchen (Dark)";
	now the printed name of the Bloodroom is "Red Room (Dark)";
	now the printed name of the Unliving Room is "Dead Room (Dark)";
	now the printed name of the Inverted Dining Room is "Dining Room (Dark)";
	now the printed name of the Inverted Second Floor is "2nd Floor (Dark)";
	now the printed name of the Trespasser's Bedroom is "Trespasser's (Dark)";
	now the printed name of the Anti-Bedroom is "Master's (Dark)";
	now the printed name of the Inverted Upper Bathroom is "Other Bathroom (Dark)";
	now the printed name of the Floating Basement is "Basement (Dark again)";
	now the printed name of the Burning Cellar is "Fire Cellar (Dark)";
	say "...";
	wait for any key;
	say "That's weird. All the light's just went off.";
	wait for any key;
	say "...";
	wait for any key;
	say "I've got a bad feeling about this.";
	now the description of the Inverted Upper Bathroom is "[italic type]Don't leave.[roman type]";
	now the description of the Inverted Second Floor is "Four ways to go.";
	now the description of the Anti-Bedroom is "[italic type]He's still here.[roman type]";
	now the description of the Trespasser's Bedroom is "[italic type]Go away![roman type]";
	now the description of the Unliving Room is "[italic type]He lives...[roman type]";
	now the description of the Inverted Dining Room is "The cake is gone.";
	now the description of the Inverted Kitchen is "[italic type]So... hungry...[roman type]";
	now the description of the Long Hallway is "[italic type]Remember him?[roman type]";
	now the description of the Bloodroom is "Flammie has left.";
	now the description of the Cemetery is "The moon is eclipsed.";
	now the description of the Inverted Lower Bathroom is "It's eerily quiet in here now.";
	now the description of the Inverted Bedroom is "[italic type]...for now.[roman type]";
	now the description of the Floating Basement is "What's that noise?";
	now the description of the Burning Cellar is "The flames are quiet.";
	now the description of the Back Dungeon is "The shrine is radiating.";
	now the cake is nowhere;
	now the description of the empty plate is "Empty again.";
	now the mouse is nowhere;
	now the white wyvern is nowhere;
	now the giant egg is nowhere;
	now the description of the grandfather clock is "The mouse inside the clock is no longer there.";
	now the description of the fire is "Their still burning but are very small and quiet now.";
	now the description of the shrine is "There's something on the altar now.";
	now the description of the altar is "The plaque's message has changed.";
	now the description of the plaque is "'[italic type]Father Time.[roman type]'";
	now the description of the inverted photos are "[italic type]Remember me?[roman type]";
	now the description of the Mudroom is "The egg has hatched.";
	now the description of the platform is "Eggshell pieces is all that's left on it.";
	now the description of the Backyard is "It became darker outside.";
	now the description of the Dining Room is "The ghostly figure has disappeared.";
	now the wisp is on the altar.
	A wisp is a thing. The wisp is fixed in place.
	The description of the wisp is "A strange glowing flame thing just sits on the altar. What a poser."
	[Geez this is a lot of code. Don't screw with any of it or the game is unplayable up to this point.]

[The wisp - "I still love them. They raised me well and that's what matters."]
Before using the gold watch on the wisp:
	say "[bold type]Note: This is the point of no return. Once you type 'Yes,' you cannot return. Saving is recommended. Are you ready?[roman type]";
	if player consents, continue the action;
	otherwise stop the action.
	
After using the gold watch on the wisp:
	say "You used your watch that you completely forgot you still had on you.";
	wait for any key;
	say "The way leading out of the dungeon closes slowly.";
	wait for any key;
	say "The wisp on the altar begins to act strangely.";
	wait for any key;
	say "Suddenly, a flash obscures your vision for a quick moment.";
	wait for any key;
	say "You regain you sight and an ominous figure appears in front of you.";
	wait for any key;
	say "It's...";
	wait for any key;
	say "you?";
	wait for any key;
	say "...";
	wait for any key;
	say "He appears to be holding something in his hand.";
	wait for any key;
	say "...";
	wait for any key;
	say "Prepare yourself... for yourself.";
	say paragraph break;
	now the player is in the Arena;
	now the dog is scared;
	now the description of the dog is "[italic type]*shivering*[roman type]".
	The Arena is a room.
	The printed name of the Arena is "[one of]%H@^e#*3&L_L$!^o0*5)#[or]^@D(#E&_7$)!a)_$&3%Th2*[or]^@N*O$_+!8)#&0E4s{C.$&Ap^9E![or]<!?CO@>$01m5@!_E*)$+H=e6r?}E)([or]\%J@oiN*_4&()t-#9>HE,//67.2D<0aRk?n@$#^eSs{$@^[or]^@*i#_!aM9+038<ERr>#/^#*@26.?oR-&1%[at random]".
	The description of the Arena is "Looks like there is no escape."
	The doppleganger is in the Arena.

[Prevent saving the game during the Final Battle - "I'm over it now."]
Check saving the game:
	if the player can see the doppleganger:
		say "Too late for that.";
		stop the action.

Section 10.1 - The Final Fight

[Doppleganger fight - "Love never says 'die,' neither do Goonies."]
[Part 1]
After attacking the doppleganger when the doppleganger is guarding:
	say "The dark twin dodges the attack and attacks you back.[line break]You take damage.";
	now the doppleganger is a random attack pattern;
	now the description of the doppleganger is "The [one of]evil demon[or]dark you[or]evil twin[or]dark demon[or]dark twin[or]other half[or]doppleganger[at random] is [attack pattern].";
	now the description of the Arena is "[one of]You feel cold.[or]Darkness is trying to consume you.[or]I see dead people.[or]He's got the stare of death.[or]Don't lose hope[or]This is going to end badly, isn't it?[or]Goosebumps form down your limbs.[or]The evil presence is lurking.[or]You must win.[or]I'll be honest with you... I'm scared.[or]You worry me.[or]Chills run down your spine.[or]Can you hear them?[or]You've met a terrible fate, haven't you.[or]What does he want from you?[or]I have faith in you.[at random]";
	now the dog is worried;
	now the description of the dog is "(Be careful.)"

After attacking the doppleganger when the doppleganger is guarding for the third time:
	end the story saying "[one of]You missed too many times and was defeated.[or]You lack of skill has brought you to your demise.[or]Strike three! Your out![at random]"

After skipping turn on the doppleganger when the doppleganger is guarding:
	say "You patiently wait for an opportunity to attack.";
	now the doppleganger is a random attack pattern;
	now the description of the doppleganger is "The [one of]evil demon[or]dark you[or]evil twin[or]dark demon[or]dark twin[or]other half[or]doppleganger[at random] is [attack pattern].";
	now the description of the Arena is "[one of]You feel cold.[or]Darkness is trying to consume you.[or]I see dead people.[or]He's got the stare of death.[or]Don't lose hope[or]This is going to end badly, isn't it?[or]Goosebumps form down your limbs.[or]The evil presence is lurking.[or]You must win.[or]I'll be honest with you... I'm scared.[or]You worry me.[or]Chills run down your spine.[or]Can you hear them?[or]You've met a terrible fate, haven't you.[or]What does he want from you?[or]I have faith in you.[at random]";
	now the dog is agitated;
	now the description of the dog is "[italic type]*Loud barking.*[roman type]"

After dodging the doppleganger when the doppleganger is guarding:
	say "[one of]You both are waiting for one of you to make a move. (Wow... what a lame fight this is turning out to be.)[or]You both stand there awkwardly waiting for someone to drop guard. (This is just ridiculous.)[or]You do realize he's guarding too, right?[at random]";
	now the doppleganger is a random attack pattern;
	now the description of the doppleganger is "The [one of]evil demon[or]dark you[or]evil twin[or]dark demon[or]dark twin[or]other half[or]doppleganger[at random] is [attack pattern].";
	now the description of the Arena is "[one of]You feel cold.[or]Darkness is trying to consume you.[or]I see dead people.[or]He's got the stare of death.[or]Don't lose hope[or]This is going to end badly, isn't it?[or]Goosebumps form down your limbs.[or]The evil presence is lurking.[or]You must win.[or]I'll be honest with you... I'm scared.[or]You worry me.[or]Chills run down your spine.[or]Can you hear them?[or]You've met a terrible fate, haven't you.[or]What does he want from you?[or]I have faith in you.[at random]";
	now the dog is unamused;
	now the description of the dog is "(You serious, mate?)"

[Part 2]
After attacking the doppleganger when the doppleganger is readying:
	say "[one of]You chose the wrong move and was overpowered by the attack.[or]You were not quick enough to attack and got hit instead.[or]You had no luck; Damaged received.[at random]";
	now the doppleganger is a random attack pattern;
	now the dog is worried;
	now the description of the dog is "(Ouch.)"

After attacking the doppleganger when the doppleganger is readying for the sixth time:
	end the story saying "[one of]The darkness managed to take you down. Better luck next time.[or]You succumbed to the darkness.[or] You had no chance of counterattacking.[at random]"

After skipping turn on the doppleganger when the doppleganger is readying:
	say "[one of]How about you actually do something else other than standing still.[or]You took damage from not doing anything, Congratulations.[or]That was not a very wise move to do.[line break]Also you got hit.[at random]";
	now the doppleganger is a random attack pattern;
	now the dog is bewildered;
	now the description of the dog is "(Um...)"

After skipping turn on the doppleganger when the doppleganger is readying for the sixth time:
	end the story saying "[one of]Because of your downright laziness in doing anything, you died a pathetic death.[or]Idiot.[or]You kind of deserved that one.[or] You are dead; Not big surprise.[at random]"

After dodging the doppleganger when the doppleganger is readying:
	say "[one of]You took no damage, good choice.[or]No damage was taken.[or]You dodged the attack just in time.[at random]";
	now the doppleganger is defenseless;
	now the dog is glad;
	now the description of the dog is "(Smart move.)"

[Part 3]
After attacking the doppleganger when the doppleganger is defenseless:
	say "[one of]Direct hit![or]Bull's eye![or]Take that, faker![or]Eat my shorts![at random]";
	now the doppleganger is a random attack pattern;
	now the dog is glad;
	now the description of the dog is "(Yeah!)"

After skipping turn on the doppleganger when the doppleganger is defenseless:
	say "[one of]Seriously? That was your chance.[or]I'm not angry, just disappointed.[or]Running around in circles could have a better move than this one.[at random]";
	now the doppleganger is guarding;
	now the dog is unamused;
	now the description of the dog is "[italic type]*Annoyed look.*[roman type]"

After dodging the doppleganger when the doppleganger is defenseless:
	say "[one of]Dude. You blew you chance on hitting him.[or](I need to find a new player after all this is over.)[or]That's not...[or]Are you feeling alright, because he was wide open that time.[at random]";
	now the doppleganger is guarding;
	now the dog is disgusted;
	now the description of the dog is "[italic type]*sigh*[roman type]"

[Final Part]
After attacking the doppleganger when the doppleganger is defenseless for the 9th time:
	say "Doppleganger: '&#*(<>+_N7^45oOooo274(*&$OooOOoo(*75&*!!!(%&??490q865^3'";
	now the doppleganger is nowhere;
	now the left hand status line is "";
	now the printed name of the Arena is "???";
	now the description of the Arena is " ";
	now the dog is in the Arena;
	now the printed name of the dog is "Australian Shepherd";
	now the dog is quiet;
	now the description of the dog is "(Take the book.)";
	wait for any key;
	say "Doppleganger: '^#*(74.<.4Y*Y&*9ujN*YB&8nLmAo\Qtbym9K_)=0-=_+(>)k(MJ*&N(Yhj,umjh_+90_(08N)_9-SML*(mh,9LPO+)_987<l/-L0.-i<*(YN78.kIj,9hm8&N&7853De+AD{-dtGBT&8rmu,&#*902{(*#&(89854++-0_*976()-=;'";
	wait for any key;
	say "Doppleganger: ' *(&HN*y78t&^%Rbt768tVCE$R6eC&$SjW:Vr%BR%3<>?<.?LOmGk,l.<MLp{PO_0_{9)9c$2q^EV$DE%^eRBN&g^&*G68yH<Ju8jk.o_+_=)-*976Hy*&MHN^NSfW&R%6E46ERb7N*Y()(*(&'";
	wait for any key;
	say "Doppleganger: 'Y&*um89y&*(T67R*T&65vr%^y>?<./mkLHui(O*)_+(87^4D%wcFgYHRoFlllU&^BVb768YM*(u89I&*Y78y&*TV56ce45xEC%$v67689<90.K/)(K<9JM(*H78BT76BT6nHMyH,>./,.<MkjbYiy*(9(0-_9)86g%RVVBNjimUYGB567r$%34xSdrfhJBNbN<WtFz,M<>m.,mJKhyuTG67G+-)(07*yBB<MNm<?,.MkHjGTyuLoLl*OI{Pp{()89(y^&f%6e%$^78()9UIBGHCrtEt%6$3Wc5DVFtygBHVTdewr$#5^TuHjBN<M>M<>nHJg^&%^$5WSEpDF*SmB><.<Kj8i:9)O()864%ecV^b*(876*&6^AcdC+=-)gNYhUU*&y&(Il0I(78$5DCdVBFUNih*)(=_TL;dRgjQ+_)_*(<l'";
	wait for any key;
	say "...";
	wait for any key;
	say "[bold type]BOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOM!!!1!1![roman type]";
	wait for any key;
	clear only the main screen;
	now the reversed book is in the Arena.
	The reversed book is a thing.
	The description of the reversed book is "The book is backwards now."

Instead of taking the dog when the dog is quiet:
	say "No."

Section 10.3 - The True Ending

[The End - "I have a debilitating fear of roller coasters. Thanks a lot uncle."]
Before taking the reversed book:
	say "Take the book?";
	fake command 3;
	continue the action.

After taking the reversed book:
	say "As you pick up the book, the dog begins to glow.";
	wait for any key;
	say "He levitates up into the air and begins to transform.";
	wait for any key;
	say "After a blinding flash of light erupts, he turns into a man.";
	wait for any key;
	say "He wears an orange vest, just like the boy in the pictures.";
	wait for any key;
	say "Is...";
	wait for any key;
	say "Is this...";
	now the dog is nowhere;
	now the unknown man is in the Arena.
	The unknown man is a man.
	The description of the unknown man is "...Micheal?"

Instead of taking the unknown man:
	say "..."

After talking to the unknown man:
	say "???: 'Hey there. Long time no see, old friend.'";
	wait for any key;
	say "???: 'You don't remember me, do you?'";
	wait for any key;
	say "???: 'I'm your old pal, Micheal.'";
	wait for any key;
	say "Micheal: 'I must thank you for dealing with that thing before. I didn't know you had it in ya.'";
	wait for any key;
	say "Micheal: 'You see, a long time ago I was working on some of my inventions that I was suppose to impress my colleagues with.'";
	wait for any key;
	say "Micheal: 'But once I was finished with that mirror portal device it started to act a little suspicious.'";
	wait for any key;
	say "Micheal: 'Next thing you know, a dark entity came out from the other side and made my other machines go on a fringe.'";
	wait for any key;
	say "Micheal: 'Short story, I was turned into a dog and all my loved ones memories of me were wiped out from existences due to the curse of this shapeshifter demon.'";
	wait for any key;
	say "Micheal: 'If you hadn't come back to find me and put an end to this devious being, I would have been lost is obscurity and not be freed by the curse of this house.'";
	wait for any key;
	say "Micheal: 'Plus who knew what would have happened if that thing managed to escape from the other side and enter the real world.'";
	wait for any key;
	say "Micheal: 'You're a hero, old sport.'";
	wait for any key;
	say "Micheal: 'Well... now that that's over with. Let's get outta here.'";
	wait for any key;
	clear only the main screen;
	now the player is in the Driveway;
	now the left hand status line is "[location]";
	say "After saving your old friend Micheal from a dreaded curse your memories of him began to flow back into you brain.";
	wait for any key;
	say "Both you and Micheal decided to lock away the mirror so that no one would ever have to see this horrible world for their own eyes.";
	wait for any key;
	say "Micheal decides to stay here to help rebuild everything he has done wrong in the past.";
	wait for any key;
	say "As for you, you decide to head back home and enjoy a nice relaxing cup of Joe for all your hard work.";
	wait for any key;
	say "Before you do leave, Micheal asks that if you ever find 'him' again to say that he's sorry for all the trouble he caused him and to take good loving care of him. He desperately needs it.";
	wait for any key;
	say "This, of course, was just what you were going to do all along.";
	wait for any key;
	say "And as you drive off into the distance, you spot a large shadow hovering past you. You stop to see what it is that's soaring above you.";
	wait for any key;
	say "It landed in the woods somewhere.";
	wait for any key;
	say "Looks like you know what to do.";
	wait for any key;
	clear only the main screen;
	center "The House of Mystery";
	wait for any key;
	center "By: James G. Lynch";
	wait for any key;
	center "Game made on Inform 7";
	wait for any key;
	say paragraph break;
	say "Special thanks to all my friends, family, colleagues, professors and you, the player, for supporting me and motivating me into making this game. This game was made as a project for my New Media Perspectives class in college. It took me about 2 freaking months to make and it was all worth it at the very end. Please let me know what you thought of this game. It was a lot of fun to make and I hope you've enjoy this 'little' project of mine.";
	wait for any key;
	now the left hand status line is "Total turns: [turn count]";
	now the right hand status line is "";
	end the story saying "[bold type]The end... for real! Thank you for playing![roman type]".